/*
 * Decompiled with CFR 0.152.
 */
package com.copicraftDev.copisTPAPlugin;

import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import net.md_5.bungee.api.ChatColor;
import net.md_5.bungee.api.chat.BaseComponent;
import net.md_5.bungee.api.chat.ClickEvent;
import net.md_5.bungee.api.chat.TextComponent;
import org.bukkit.Bukkit;
import org.bukkit.Location;
import org.bukkit.Particle;
import org.bukkit.Sound;
import org.bukkit.command.Command;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.java.JavaPlugin;
import org.bukkit.scheduler.BukkitRunnable;

public final class CopisTPAPlugin
extends JavaPlugin {
    private final Map<UUID, UUID> tpaRequests = new HashMap<UUID, UUID>();
    private final Map<UUID, UUID> tpahereRequests = new HashMap<UUID, UUID>();
    private final Map<UUID, Location> teleportStart = new HashMap<UUID, Location>();
    private final Map<UUID, UUID> activeTeleport = new HashMap<UUID, UUID>();
    private static final int REQUEST_TIMEOUT = 60;
    private static final int TELEPORT_DELAY = 5;

    public void onEnable() {
        this.getLogger().info("CopisTPA v3.1 enabled!");
    }

    public void onDisable() {
        this.getLogger().info("CopisTPA disabled!");
    }

    public boolean onCommand(CommandSender sender, Command command, String label, String[] args) {
        if (!(sender instanceof Player)) {
            return false;
        }
        Player player = (Player)sender;
        switch (command.getName().toLowerCase()) {
            case "tpa": {
                return this.handleTPA(player, args, true);
            }
            case "tpahere": {
                return this.handleTPA(player, args, false);
            }
            case "tpaccept": {
                return this.handleTPAccept(player);
            }
            case "tpdeny": {
                return this.handleTPDeny(player);
            }
        }
        return false;
    }

    private boolean handleTPA(Player player, String[] args, boolean isTpa) {
        if (args.length < 1) {
            player.sendMessage("\u00a7cUsage: /" + (isTpa ? "tpa" : "tpahere") + " <player>");
            return true;
        }
        Player target = Bukkit.getPlayer((String)args[0]);
        if (target == null || !target.isOnline()) {
            player.sendMessage("\u00a7cPlayer not found!");
            return true;
        }
        if (isTpa) {
            this.tpaRequests.put(target.getUniqueId(), player.getUniqueId());
        } else {
            this.tpahereRequests.put(target.getUniqueId(), player.getUniqueId());
        }
        TextComponent message = new TextComponent("\u00a7e" + player.getName() + " \u00a7awants to " + (isTpa ? "teleport to you! " : "have you teleport to them! "));
        TextComponent accept = new TextComponent("[Accept]");
        accept.setColor(ChatColor.GREEN);
        accept.setBold(Boolean.valueOf(true));
        accept.setClickEvent(new ClickEvent(ClickEvent.Action.RUN_COMMAND, "/tpaccept"));
        TextComponent deny = new TextComponent("[Deny]");
        deny.setColor(ChatColor.RED);
        deny.setBold(Boolean.valueOf(true));
        deny.setClickEvent(new ClickEvent(ClickEvent.Action.RUN_COMMAND, "/tpdeny"));
        message.addExtra((BaseComponent)accept);
        message.addExtra(" ");
        message.addExtra((BaseComponent)deny);
        target.spigot().sendMessage((BaseComponent)message);
        player.sendMessage("\u00a7aTeleport request sent to \u00a7e" + target.getName());
        this.scheduleRequestTimeout(target.getUniqueId(), isTpa);
        return true;
    }

    private boolean handleTPAccept(final Player player) {
        boolean isTpa;
        UUID requesterId = null;
        if (this.tpaRequests.containsKey(player.getUniqueId())) {
            requesterId = this.tpaRequests.remove(player.getUniqueId());
            isTpa = true;
        } else {
            isTpa = false;
            if (this.tpahereRequests.containsKey(player.getUniqueId())) {
                requesterId = this.tpahereRequests.remove(player.getUniqueId());
            }
        }
        if (requesterId == null) {
            player.sendMessage("\u00a7cYou have no pending teleport requests.");
            return true;
        }
        final Player requester = Bukkit.getPlayer((UUID)requesterId);
        if (requester == null || !requester.isOnline()) {
            player.sendMessage("\u00a7cRequester is no longer online.");
            return true;
        }
        final Location destination = isTpa ? player.getLocation() : requester.getLocation();
        final Player teleporting = isTpa ? requester : player;
        this.teleportStart.put(teleporting.getUniqueId(), teleporting.getLocation());
        this.activeTeleport.put(teleporting.getUniqueId(), destination.getWorld().getUID());
        teleporting.sendMessage("\u00a7eStand still for 5 seconds to teleport...");
        new BukkitRunnable(){
            int counter = 0;

            public void run() {
                if (!teleporting.isOnline()) {
                    this.cancelTeleport();
                    this.cancel();
                    return;
                }
                Location start = CopisTPAPlugin.this.teleportStart.get(teleporting.getUniqueId());
                if (start == null) {
                    this.cancelTeleport();
                    this.cancel();
                    return;
                }
                Location current = teleporting.getLocation();
                if (!current.getBlock().equals((Object)start.getBlock())) {
                    teleporting.sendMessage("\u00a7cTeleport cancelled because you moved!");
                    this.cancelTeleport();
                    this.cancel();
                    return;
                }
                if (!current.getBlock().getType().isAir()) {
                    teleporting.sendMessage("\u00a7cTeleport cancelled! You are inside a block.");
                    this.cancelTeleport();
                    this.cancel();
                    return;
                }
                if (current.getY() < start.getY() - 1.0) {
                    teleporting.sendMessage("\u00a7cTeleport cancelled! You are falling.");
                    this.cancelTeleport();
                    this.cancel();
                    return;
                }
                teleporting.getWorld().spawnParticle(Particle.PORTAL, current.add(0.0, 1.0, 0.0), 10, 0.5, 1.0, 0.5, 0.1);
                teleporting.getWorld().playSound(current, Sound.BLOCK_BEACON_POWER_SELECT, 0.5f, 1.0f);
                ++this.counter;
                if (this.counter >= 5) {
                    teleporting.teleport(destination);
                    teleporting.sendMessage("\u00a7aTeleported successfully!");
                    if (isTpa) {
                        player.sendMessage("\u00a7e" + requester.getName() + " \u00a7ahas teleported to you.");
                    } else {
                        requester.sendMessage("\u00a7e" + player.getName() + " \u00a7ahas teleported to you.");
                    }
                    this.cancelTeleport();
                    this.cancel();
                }
            }

            private void cancelTeleport() {
                CopisTPAPlugin.this.teleportStart.remove(teleporting.getUniqueId());
                CopisTPAPlugin.this.activeTeleport.remove(teleporting.getUniqueId());
            }
        }.runTaskTimer((Plugin)this, 20L, 20L);
        return true;
    }

    private boolean handleTPDeny(Player player) {
        UUID requesterId = null;
        if (this.tpaRequests.containsKey(player.getUniqueId())) {
            requesterId = this.tpaRequests.remove(player.getUniqueId());
        } else if (this.tpahereRequests.containsKey(player.getUniqueId())) {
            requesterId = this.tpahereRequests.remove(player.getUniqueId());
        }
        if (requesterId == null) {
            player.sendMessage("\u00a7cYou have no pending teleport requests.");
            return true;
        }
        Player requester = Bukkit.getPlayer((UUID)requesterId);
        if (requester != null && requester.isOnline()) {
            requester.sendMessage("\u00a7c" + player.getName() + " denied your teleport request.");
        }
        player.sendMessage("\u00a7cTeleport request denied.");
        return true;
    }

    private void scheduleRequestTimeout(final UUID target, final boolean isTpa) {
        new BukkitRunnable(){

            public void run() {
                Player requester;
                if (isTpa && CopisTPAPlugin.this.tpaRequests.containsKey(target) && (requester = Bukkit.getPlayer((UUID)CopisTPAPlugin.this.tpaRequests.remove(target))) != null && requester.isOnline()) {
                    requester.sendMessage("\u00a7cYour teleport request timed out.");
                }
                if (!isTpa && CopisTPAPlugin.this.tpahereRequests.containsKey(target) && (requester = Bukkit.getPlayer((UUID)CopisTPAPlugin.this.tpahereRequests.remove(target))) != null && requester.isOnline()) {
                    requester.sendMessage("\u00a7cYour teleport request timed out.");
                }
            }
        }.runTaskLater((Plugin)this, 1200L);
    }
}

