/*
 * Decompiled with CFR 0.152.
 */
package de.sarocesch.sarosfruittreesmod.util;

import de.sarocesch.sarosfruittreesmod.block.FruitLeaveBlock;
import de.sarocesch.sarosfruittreesmod.init.SarosFruitTreesModModBlocks;
import net.minecraft.class_1936;
import net.minecraft.class_2246;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2397;
import net.minecraft.class_2680;
import net.minecraft.class_2741;
import net.minecraft.class_2769;
import net.minecraft.class_3218;
import net.minecraft.class_5819;

public class WorldGenTreeHelper {
    public static void updateFruitLeaveBlocks(class_1936 world, double centerX, double centerY, double centerZ, int radius, int height, FruitLeaveBlock.FruitType fruitType) {
        class_2248 fruitLeaveBlock = SarosFruitTreesModModBlocks.FRUIT_LEAVE;
        FruitLeaveBlock.GrowthStage[] allStages = FruitLeaveBlock.GrowthStage.values();
        WorldGenTreeHelper.fixWaterloggedLeaves(world, centerX, centerY, centerZ, radius, height);
        for (int dx = -radius; dx <= radius; ++dx) {
            for (int dy = 0; dy <= height; ++dy) {
                for (int dz = -radius; dz <= radius; ++dz) {
                    class_2338 pos = new class_2338((int)(centerX + (double)dx), (int)(centerY + (double)dy), (int)(centerZ + (double)dz));
                    class_2680 state = world.method_8320(pos);
                    if (state.method_26204() != fruitLeaveBlock) continue;
                    boolean shouldUpdate = true;
                    if (state.method_28498(FruitLeaveBlock.FRUIT_TYPE)) {
                        FruitLeaveBlock.FruitType currentType = (FruitLeaveBlock.FruitType)((Object)state.method_11654(FruitLeaveBlock.FRUIT_TYPE));
                        boolean bl = shouldUpdate = currentType == FruitLeaveBlock.FruitType.APPLE || currentType == fruitType;
                    }
                    if (!shouldUpdate) continue;
                    FruitLeaveBlock.GrowthStage randomStage = allStages[world instanceof class_3218 ? ((class_3218)world).method_8409().method_43048(allStages.length) : (int)(Math.random() * (double)allStages.length)];
                    class_2680 newState = (class_2680)((class_2680)fruitLeaveBlock.method_9564().method_11657(FruitLeaveBlock.FRUIT_TYPE, (Comparable)((Object)fruitType))).method_11657(FruitLeaveBlock.GROWTH_STAGE, (Comparable)((Object)randomStage));
                    if (newState.method_28498((class_2769)class_2741.field_12508)) {
                        newState = (class_2680)newState.method_11657((class_2769)class_2741.field_12508, (Comparable)Boolean.valueOf(false));
                    }
                    if (newState.method_28498((class_2769)class_2397.field_11199)) {
                        newState = (class_2680)newState.method_11657((class_2769)class_2397.field_11199, (Comparable)Integer.valueOf(1));
                    }
                    if (newState.method_28498((class_2769)class_2741.field_12514)) {
                        newState = (class_2680)newState.method_11657((class_2769)class_2741.field_12514, (Comparable)Boolean.valueOf(false));
                    }
                    world.method_8652(pos, newState, 3);
                }
            }
        }
        WorldGenTreeHelper.fixWaterloggedLeaves(world, centerX, centerY, centerZ, radius, height);
    }

    public static void fixWaterloggedLeaves(class_1936 world, double centerX, double centerY, double centerZ, int radius, int height) {
        for (int dx = -radius; dx <= radius; ++dx) {
            for (int dy = 0; dy <= height; ++dy) {
                for (int dz = -radius; dz <= radius; ++dz) {
                    class_2338 pos = new class_2338((int)(centerX + (double)dx), (int)(centerY + (double)dy), (int)(centerZ + (double)dz));
                    class_2680 state = world.method_8320(pos);
                    if (!(state.method_26204() instanceof class_2397) && state.method_26204() != SarosFruitTreesModModBlocks.FRUIT_LEAVE || !state.method_28498((class_2769)class_2741.field_12508) || !((Boolean)state.method_11654((class_2769)class_2741.field_12508)).booleanValue()) continue;
                    world.method_8652(pos, (class_2680)state.method_11657((class_2769)class_2741.field_12508, (Comparable)Boolean.valueOf(false)), 3);
                }
            }
        }
    }

    public static void updateLeafConnections(class_1936 world, double centerX, double centerY, double centerZ, int radius, int height) {
        for (int dx = -radius; dx <= radius; ++dx) {
            for (int dy = 0; dy <= height; ++dy) {
                for (int dz = -radius; dz <= radius; ++dz) {
                    class_2338 pos = new class_2338((int)(centerX + (double)dx), (int)(centerY + (double)dy), (int)(centerZ + (double)dz));
                    class_2680 state = world.method_8320(pos);
                    if (state.method_26204() != SarosFruitTreesModModBlocks.FRUIT_LEAVE && state.method_26204() != class_2246.field_10503) continue;
                    if (state.method_28498((class_2769)class_2741.field_12514) && ((Boolean)state.method_11654((class_2769)class_2741.field_12514)).booleanValue()) {
                        world.method_8652(pos, (class_2680)state.method_11657((class_2769)class_2741.field_12514, (Comparable)Boolean.valueOf(false)), 3);
                    }
                    if (!state.method_28498((class_2769)class_2397.field_11199) || (Integer)state.method_11654((class_2769)class_2397.field_11199) <= 1) continue;
                    world.method_8652(pos, (class_2680)state.method_11657((class_2769)class_2397.field_11199, (Comparable)Integer.valueOf(1)), 3);
                }
            }
        }
    }

    public static String getRandomTreeStructureName(class_5819 random) {
        String[] treeStructureNames = new String[]{"baum1", "baum2", "baum3", "baum4", "baum5"};
        return treeStructureNames[random.method_43048(treeStructureNames.length)];
    }

    public static FruitLeaveBlock.FruitType getRandomFruitType(class_5819 random) {
        FruitLeaveBlock.FruitType[] allowedTypes = new FruitLeaveBlock.FruitType[]{FruitLeaveBlock.FruitType.APPLE, FruitLeaveBlock.FruitType.ORANGE, FruitLeaveBlock.FruitType.PEAR};
        return allowedTypes[random.method_43048(allowedTypes.length)];
    }

    public static int getTreeGroupSize(class_5819 random) {
        int roll = random.method_43048(100);
        if (roll < 60) {
            return 1;
        }
        if (roll < 85) {
            return 3;
        }
        return 5;
    }

    public static int[] getVeinOffset(class_5819 random, int index, int groupSize) {
        int baseDistance = 7;
        if (groupSize == 1) {
            return new int[]{0, 0};
        }
        if (index == 0) {
            return new int[]{0, 0};
        }
        int direction = random.method_43048(8);
        int distance = baseDistance + index * 3 + random.method_43048(4);
        int xOffset = 0;
        int zOffset = 0;
        switch (direction) {
            case 0: {
                zOffset = -distance;
                break;
            }
            case 1: {
                xOffset = distance;
                break;
            }
            case 2: {
                zOffset = distance;
                break;
            }
            case 3: {
                xOffset = -distance;
                break;
            }
            case 4: {
                xOffset = distance;
                zOffset = -distance;
                break;
            }
            case 5: {
                xOffset = distance;
                zOffset = distance;
                break;
            }
            case 6: {
                xOffset = -distance;
                zOffset = distance;
                break;
            }
            case 7: {
                xOffset = -distance;
                zOffset = -distance;
            }
        }
        return new int[]{xOffset += random.method_43048(5) - 2, zOffset += random.method_43048(5) - 2};
    }
}

