/*
 * Decompiled with CFR 0.152.
 */
package com.christofmeg.justenoughbreeding.serializer;

import com.christofmeg.justenoughbreeding.JustEnoughBreeding;
import com.christofmeg.justenoughbreeding.recipe.BaseRecipe;
import com.christofmeg.justenoughbreeding.recipe.TransformationRecipe;
import com.christofmeg.justenoughbreeding.utils.CommonUtils;
import com.christofmeg.justenoughbreeding.utils.Utils;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import net.minecraft.class_1299;
import net.minecraft.class_1767;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1856;
import net.minecraft.class_1865;
import net.minecraft.class_2540;
import net.minecraft.class_2960;
import org.jetbrains.annotations.NotNull;

public class TransformationSerializer
implements class_1865<TransformationRecipe> {
    @NotNull
    public TransformationRecipe fromJson(@NotNull class_2960 jsonPath, @NotNull JsonObject json) {
        return (TransformationRecipe)TransformationSerializer.readJsonContents(jsonPath, json);
    }

    @NotNull
    public TransformationRecipe fromNetwork(@NotNull class_2960 id, @NotNull class_2540 buf) {
        class_2960 inputEntityId = buf.method_10810();
        class_1299<?> inputEntityType = JustEnoughBreeding.getEntityFromLoaderRegistries(inputEntityId);
        if (inputEntityType == null) {
            throw new JsonParseException("Unknown input EntityType in TransformationRecipe#fromNetwork: " + inputEntityId);
        }
        class_2960 outputEntityId = buf.method_10810();
        class_1299<?> outputEntityType = JustEnoughBreeding.getEntityFromLoaderRegistries(outputEntityId);
        if (outputEntityType == null) {
            throw new JsonParseException("Unknown output EntityType in TransformationRecipe#fromNetwork: " + outputEntityId);
        }
        class_1856 inputStack = class_1856.method_8086((class_2540)buf);
        class_1856 inputSpawnEgg = class_1856.method_8086((class_2540)buf);
        boolean hasExtraInput = buf.readBoolean();
        class_1856 extraInputStack = hasExtraInput ? class_1856.method_8086((class_2540)buf) : class_1856.field_9017;
        class_1856 outputSpawnEgg = class_1856.method_8086((class_2540)buf);
        Boolean needsToBeTamed = buf.readBoolean() ? Boolean.valueOf(buf.readBoolean()) : null;
        String jsonModID = buf.method_19772();
        String modFolder = buf.method_19772();
        String fileName = buf.method_19772();
        class_1767 inputColor = buf.readBoolean() ? class_1767.method_7791((int)buf.method_10816()) : null;
        class_1767 outputColor = buf.readBoolean() ? class_1767.method_7791((int)buf.method_10816()) : null;
        return new TransformationRecipe(inputEntityType, inputStack, inputSpawnEgg, extraInputStack, outputEntityType, outputSpawnEgg, needsToBeTamed, jsonModID, modFolder, fileName, inputColor, outputColor);
    }

    public void toNetwork(@NotNull class_2540 buf, @NotNull TransformationRecipe recipe) {
        class_2960 inKey = JustEnoughBreeding.getKeyLoaderRegistries(recipe.inputEntityType);
        class_2960 outKey = JustEnoughBreeding.getKeyLoaderRegistries(recipe.outputEntityType);
        if (inKey == null || outKey == null) {
            throw new JsonParseException("Unknown EntityType in TransformationRecipe: " + recipe.inputEntityType + " / " + recipe.outputEntityType);
        }
        buf.method_10812(inKey);
        buf.method_10812(outKey);
        CommonUtils.safe(recipe.inputStack).method_8088(buf);
        CommonUtils.safe(recipe.inputSpawnEgg).method_8088(buf);
        boolean hasExtra = recipe.extraInputStack != null && !recipe.extraInputStack.method_8103();
        buf.writeBoolean(hasExtra);
        if (hasExtra) {
            recipe.extraInputStack.method_8088(buf);
        }
        CommonUtils.safe(recipe.outputSpawnEgg).method_8088(buf);
        if (recipe.needsToBeTamed != null) {
            buf.writeBoolean(true);
            buf.writeBoolean(recipe.needsToBeTamed.booleanValue());
        } else {
            buf.writeBoolean(false);
        }
        buf.method_10814(recipe.jsonModID);
        buf.method_10814(recipe.modFolder);
        buf.method_10814(recipe.fileName);
        if (recipe.inputColor != null) {
            buf.writeBoolean(true);
            buf.method_10804(recipe.inputColor.method_7789());
        } else {
            buf.writeBoolean(false);
        }
        if (recipe.outputColor != null) {
            buf.writeBoolean(true);
            buf.method_10804(recipe.outputColor.method_7789());
        } else {
            buf.writeBoolean(false);
        }
    }

    public static BaseRecipe readJsonContents(@NotNull class_2960 jsonPath, @NotNull JsonObject json) {
        class_1799 spawnEgg;
        String jsonModID = json.get("mod").getAsString();
        String modFolder = jsonPath.method_12836();
        String fileName = jsonPath.method_12832().substring(jsonPath.method_12832().lastIndexOf(47) + 1);
        if (jsonPath.method_12836().equals("justenoughbreeding")) {
            modFolder = jsonPath.method_12832().split("/")[1];
        }
        if (!JustEnoughBreeding.isModLoaded(modFolder) || !JustEnoughBreeding.isModLoaded(jsonModID)) {
            return new TransformationRecipe.DummyRecipe(jsonModID, modFolder, fileName);
        }
        ArrayList<class_1856> inputIngredients = new ArrayList<class_1856>();
        ArrayList<class_1856> extraInputIngredients = new ArrayList<class_1856>();
        ArrayList<class_1856> inputSpawnEggs = new ArrayList<class_1856>();
        ArrayList<class_1856> outputSpawnEggs = new ArrayList<class_1856>();
        class_1299<?> inputEntityType = null;
        if (json.has("input_entity")) {
            String input_entity = json.get("input_entity").getAsString();
            inputEntityType = JustEnoughBreeding.getEntityFromLoaderRegistries(new class_2960(input_entity));
        }
        class_1299<?> outputEntityType = null;
        if (json.has("output_entity")) {
            String outputEntity = json.get("output_entity").getAsString();
            outputEntityType = JustEnoughBreeding.getEntityFromLoaderRegistries(new class_2960(outputEntity));
        }
        if (inputEntityType == null || outputEntityType == null) {
            throw new JsonParseException("Transformation recipe missing/unknown entities in " + jsonPath);
        }
        Utils.addIngredients(json, inputIngredients, "inputs");
        Utils.addIngredients(json, extraInputIngredients, "extra_inputs");
        Utils.addIngredients(json, inputSpawnEggs, "input_spawn_eggs");
        Utils.addIngredients(json, outputSpawnEggs, "output_spawn_eggs");
        if (inputSpawnEggs.isEmpty()) {
            spawnEgg = Optional.ofNullable(JustEnoughBreeding.getSpawnEggItem(inputEntityType)).map(class_1792::method_7854).orElse(class_1799.field_8037);
            inputSpawnEggs = new ArrayList<class_1856>(List.of(class_1856.method_8101((class_1799[])new class_1799[]{spawnEgg})));
        }
        if (outputSpawnEggs.isEmpty()) {
            spawnEgg = Optional.ofNullable(JustEnoughBreeding.getSpawnEggItem(outputEntityType)).map(class_1792::method_7854).orElse(class_1799.field_8037);
            outputSpawnEggs = new ArrayList<class_1856>(List.of(class_1856.method_8101((class_1799[])new class_1799[]{spawnEgg})));
        }
        for (TransformationRecipe existingRecipe : JustEnoughBreeding.transformationRecipes) {
            if (!existingRecipe.method_8114().equals((Object)jsonPath)) continue;
            inputIngredients.add(existingRecipe.inputStack);
            extraInputIngredients.add(existingRecipe.extraInputStack);
            inputSpawnEggs.add(existingRecipe.inputSpawnEgg);
            outputSpawnEggs.add(existingRecipe.outputSpawnEgg);
            existingRecipe.setInputIngredient(Utils.deduplicateIngredients(inputIngredients));
            existingRecipe.setExtraInputIngredient(Utils.deduplicateIngredients(extraInputIngredients));
            existingRecipe.setInputSpawnEggs(Utils.deduplicateIngredients(inputSpawnEggs));
            existingRecipe.setOutputSpawnEggs(Utils.deduplicateIngredients(outputSpawnEggs));
            return existingRecipe;
        }
        boolean isTamed = json.has("tamed") && json.get("tamed").getAsBoolean();
        class_1767 inputColor = json.has("input_color") ? class_1767.valueOf((String)json.get("input_color").getAsString().toUpperCase()) : null;
        class_1767 outputColor = json.has("output_color") ? class_1767.valueOf((String)json.get("output_color").getAsString().toUpperCase()) : null;
        TransformationRecipe transformationRecipe = new TransformationRecipe(inputEntityType, Utils.deduplicateIngredients(inputIngredients), Utils.deduplicateIngredients(inputSpawnEggs), Utils.deduplicateIngredients(extraInputIngredients), outputEntityType, Utils.deduplicateIngredients(outputSpawnEggs), isTamed, jsonModID, modFolder, fileName, inputColor, outputColor);
        JustEnoughBreeding.transformationRecipes.add(transformationRecipe);
        return transformationRecipe;
    }
}

