/*
 * Decompiled with CFR 0.152.
 */
package com.christofmeg.justenoughbreeding.utils;

import com.christofmeg.justenoughbreeding.JustEnoughBreeding;
import com.christofmeg.justenoughbreeding.recipe.AllayDuplicationRecipe;
import com.christofmeg.justenoughbreeding.recipe.BaseRecipe;
import com.christofmeg.justenoughbreeding.recipe.BreedingRecipe;
import com.christofmeg.justenoughbreeding.recipe.TamingRecipe;
import com.christofmeg.justenoughbreeding.recipe.TemperRecipe;
import com.christofmeg.justenoughbreeding.recipe.TransformationRecipe;
import com.christofmeg.justenoughbreeding.recipe.TrustingRecipe;
import com.christofmeg.justenoughbreeding.utils.CommonUtils;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import net.minecraft.class_1299;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1826;
import net.minecraft.class_1856;
import net.minecraft.class_1935;
import net.minecraft.class_2487;
import net.minecraft.class_2522;
import net.minecraft.class_2960;
import net.minecraft.class_5321;
import net.minecraft.class_6862;
import net.minecraft.class_7924;
import org.jetbrains.annotations.NotNull;

public class Utils {
    public static class_1856 merge(List<class_1856> ingredients) {
        JsonArray array = new JsonArray();
        for (class_1856 ing : ingredients) {
            if (ing == null || ing == class_1856.field_9017) continue;
            JsonElement json = ing.method_8089();
            if (json.isJsonArray()) {
                for (JsonElement e : json.getAsJsonArray()) {
                    if (array.contains(e)) continue;
                    array.add(e);
                }
                continue;
            }
            if (array.contains(json)) continue;
            array.add(json);
        }
        if (array.size() == 0) {
            return class_1856.field_9017;
        }
        return class_1856.method_52177((JsonElement)array);
    }

    public static class_1856 createCombinedIngredient(String mobIngredients) {
        String[] ingredientIds = mobIngredients.split(",");
        ArrayList<class_1856> combinedIngredients = new ArrayList<class_1856>();
        for (String ingredientId : ingredientIds) {
            if (ingredientId.trim().startsWith("#")) {
                combinedIngredients.add(CommonUtils.createTagIngredient(ingredientId));
                continue;
            }
            class_1792 ingredientItem = JustEnoughBreeding.getItemFromLoaderRegistries(new class_2960(ingredientId.trim()));
            if (ingredientItem == null) continue;
            combinedIngredients.add(class_1856.method_8101((class_1799[])new class_1799[]{new class_1799((class_1935)ingredientItem)}));
        }
        return Utils.merge(combinedIngredients);
    }

    public static class_1856 createCombinedIngredientFromTag(String mobIngredients) {
        ArrayList<class_1856> combinedIngredients = new ArrayList<class_1856>();
        class_2960 tagLocation = new class_2960(mobIngredients.trim());
        combinedIngredients.add(class_1856.method_8106((class_6862)class_6862.method_40092((class_5321)class_7924.field_41197, (class_2960)tagLocation)));
        return Utils.merge(combinedIngredients);
    }

    public static class_1856 createCombinedIngredient(String mobIngredients, int amount, class_2487 nbt) {
        ArrayList<class_1856> combinedIngredients = new ArrayList<class_1856>();
        class_1792 ingredientItem = JustEnoughBreeding.getItemFromLoaderRegistries(new class_2960(mobIngredients.trim()));
        if (ingredientItem != null) {
            class_1799 stack = new class_1799((class_1935)ingredientItem, amount);
            if (nbt != null) {
                stack.method_7980(nbt);
            }
            combinedIngredients.add(class_1856.method_8101((class_1799[])new class_1799[]{stack}));
        }
        return Utils.merge(combinedIngredients);
    }

    public static void addIngredients(JsonObject mobData, List<class_1856> ingredientList, String memberName) {
        if (mobData.has(memberName)) {
            for (JsonElement input : mobData.getAsJsonArray(memberName)) {
                class_2487 nbt = null;
                if (input.getAsJsonObject().has("nbt")) {
                    try {
                        nbt = class_2522.method_10718((String)input.getAsJsonObject().get("nbt").getAsString());
                    }
                    catch (CommandSyntaxException e) {
                        System.err.println("Invalid NBT data: {}" + input.getAsJsonObject().get("nbt").getAsString());
                    }
                }
                if (input.getAsJsonObject().has("item")) {
                    String ingredient = input.getAsJsonObject().get("item").getAsString();
                    JsonElement amountElement = input.getAsJsonObject().get("amount");
                    if (amountElement != null && amountElement.isJsonObject()) {
                        JsonObject amountObj = amountElement.getAsJsonObject();
                        int min = amountObj.has("min") ? amountObj.get("min").getAsInt() : 1;
                        int max = amountObj.has("max") ? amountObj.get("max").getAsInt() : min;
                        for (int i = min; i <= max; ++i) {
                            ingredientList.add(Utils.createCombinedIngredient(ingredient, i, nbt));
                        }
                        continue;
                    }
                    int amount = input.getAsJsonObject().has("amount") ? input.getAsJsonObject().get("amount").getAsInt() : 1;
                    ingredientList.add(Utils.createCombinedIngredient(ingredient, amount, nbt));
                    continue;
                }
                if (input.getAsJsonObject().has("tag")) {
                    String ingredient = input.getAsJsonObject().get("tag").getAsString();
                    ingredientList.add(Utils.createCombinedIngredientFromTag(ingredient));
                    continue;
                }
                if (!input.getAsJsonObject().has("meat")) continue;
                boolean meat = input.getAsJsonObject().get("meat").getAsBoolean();
                ingredientList.add(Utils.createCombinedIngredient(CommonUtils.getEdibleMeatItemNames(meat)));
            }
        }
    }

    public static BaseRecipe readJsonContents(@NotNull class_2960 jsonPath, @NotNull JsonObject json, String recipeType) {
        class_1299<?> entityType;
        JsonArray mobs = json.getAsJsonArray("mobs");
        JsonObject mobObject = mobs.get(0).getAsJsonObject();
        Map.Entry mobEntry = (Map.Entry)mobObject.entrySet().iterator().next();
        String jsonModID = json.get("mod").getAsString();
        String jsonAnimalID = (String)mobEntry.getKey();
        String modFolder = jsonPath.method_12836();
        String fileName = jsonPath.method_12832().substring(jsonPath.method_12832().lastIndexOf(47) + 1);
        if (jsonPath.method_12836().equals("justenoughbreeding")) {
            modFolder = jsonPath.method_12832().split("/")[1];
        }
        if (!JustEnoughBreeding.isModLoaded(modFolder) || !JustEnoughBreeding.isModLoaded(jsonModID)) {
            switch (recipeType) {
                case "allay_duplication": {
                    return new AllayDuplicationRecipe.DummyRecipe(jsonModID, jsonAnimalID, modFolder, fileName);
                }
                case "breeding": {
                    return new BreedingRecipe.DummyRecipe(jsonModID, jsonAnimalID, modFolder, fileName);
                }
                case "taming": {
                    return new TamingRecipe.DummyRecipe(jsonModID, jsonAnimalID, modFolder, fileName);
                }
                case "temper": {
                    return new TemperRecipe.DummyRecipe(jsonModID, jsonAnimalID, modFolder, fileName);
                }
                case "transformation": {
                    return new TransformationRecipe.DummyRecipe(jsonModID, modFolder, fileName);
                }
                case "trusting": {
                    return new TrustingRecipe.DummyRecipe(jsonModID, jsonAnimalID, modFolder, fileName);
                }
            }
        }
        if ((entityType = JustEnoughBreeding.getEntityFromLoaderRegistries(new class_2960(jsonModID, jsonAnimalID))) == null) {
            throw new JsonParseException("Unknown entity: " + jsonModID + ":" + jsonAnimalID + " in " + jsonPath);
        }
        if (!jsonAnimalID.equals(entityType.method_35050())) {
            throw new JsonParseException("Entity id mismatch. jsonAnimalID=" + jsonAnimalID + " != " + entityType.method_35050() + " in " + jsonPath);
        }
        ArrayList<class_1856> inputIngredients = new ArrayList<class_1856>();
        ArrayList<class_1856> extraInputIngredients = new ArrayList<class_1856>();
        ArrayList<class_1856> outputIngredients = new ArrayList<class_1856>();
        ArrayList<class_1856> spawnEggs = new ArrayList<class_1856>();
        JsonObject mobData = ((JsonElement)mobEntry.getValue()).getAsJsonObject();
        Utils.addIngredients(mobData, inputIngredients, "inputs");
        Utils.addIngredients(mobData, extraInputIngredients, "extra_inputs");
        Utils.addIngredients(mobData, outputIngredients, "outputs");
        if (mobData.has("spawn_eggs")) {
            Utils.addIngredients(mobData, spawnEggs, "spawn_eggs");
        } else {
            class_1799 spawnEgg = Optional.ofNullable(class_1826.method_8019(entityType)).map(class_1792::method_7854).orElse(class_1799.field_8037);
            spawnEggs = new ArrayList<class_1856>(List.of(class_1856.method_8101((class_1799[])new class_1799[]{spawnEgg})));
        }
        switch (recipeType) {
            case "trusting": {
                for (TrustingRecipe existingRecipe : JustEnoughBreeding.trustingRecipes) {
                    if (!existingRecipe.jsonModID.equals(jsonModID) || !existingRecipe.jsonAnimalID.equals(jsonAnimalID)) continue;
                    inputIngredients.add(existingRecipe.inputStack);
                    spawnEggs.add(existingRecipe.spawnEgg);
                    extraInputIngredients.add(existingRecipe.extraInputStack);
                    existingRecipe.setInputIngredient(Utils.deduplicateIngredients(inputIngredients));
                    existingRecipe.setExtraInputIngredient(Utils.deduplicateIngredients(extraInputIngredients));
                    existingRecipe.setSpawnEggs(Utils.deduplicateIngredients(spawnEggs));
                    return existingRecipe;
                }
                TrustingRecipe trustingRecipe = new TrustingRecipe(entityType, Utils.deduplicateIngredients(inputIngredients), Utils.deduplicateIngredients(spawnEggs), Utils.deduplicateIngredients(extraInputIngredients), jsonModID, jsonAnimalID, modFolder, fileName);
                JustEnoughBreeding.trustingRecipes.add(trustingRecipe);
                return trustingRecipe;
            }
            case "taming": {
                for (TamingRecipe existingRecipe : JustEnoughBreeding.tamingRecipes) {
                    if (!existingRecipe.jsonModID.equals(jsonModID) || !existingRecipe.jsonAnimalID.equals(jsonAnimalID)) continue;
                    inputIngredients.add(existingRecipe.inputStack);
                    spawnEggs.add(existingRecipe.spawnEgg);
                    extraInputIngredients.add(existingRecipe.extraInputStack);
                    existingRecipe.setInputIngredient(Utils.deduplicateIngredients(inputIngredients));
                    existingRecipe.setExtraInputIngredient(Utils.deduplicateIngredients(extraInputIngredients));
                    existingRecipe.setSpawnEggs(Utils.deduplicateIngredients(spawnEggs));
                    return existingRecipe;
                }
                TamingRecipe tamingRecipe = new TamingRecipe(entityType, Utils.deduplicateIngredients(inputIngredients), Utils.deduplicateIngredients(spawnEggs), Utils.deduplicateIngredients(extraInputIngredients), jsonModID, jsonAnimalID, modFolder, fileName);
                JustEnoughBreeding.tamingRecipes.add(tamingRecipe);
                return tamingRecipe;
            }
            case "allay_duplication": {
                for (AllayDuplicationRecipe existingRecipe : JustEnoughBreeding.allayDuplicationRecipes) {
                    if (!existingRecipe.jsonModID.equals(jsonModID) || !existingRecipe.jsonAnimalID.equals(jsonAnimalID)) continue;
                    inputIngredients.add(existingRecipe.inputStack);
                    spawnEggs.add(existingRecipe.spawnEgg);
                    existingRecipe.setInputIngredient(Utils.deduplicateIngredients(inputIngredients));
                    existingRecipe.setSpawnEggs(Utils.deduplicateIngredients(spawnEggs));
                    return existingRecipe;
                }
                AllayDuplicationRecipe allayDuplicationRecipe = new AllayDuplicationRecipe(entityType, Utils.deduplicateIngredients(inputIngredients), Utils.deduplicateIngredients(spawnEggs), jsonModID, jsonAnimalID, modFolder, fileName);
                JustEnoughBreeding.allayDuplicationRecipes.add(allayDuplicationRecipe);
                return allayDuplicationRecipe;
            }
        }
        for (BreedingRecipe existingRecipe : JustEnoughBreeding.breedingRecipes) {
            if (!existingRecipe.jsonModID.equals(jsonModID) || !existingRecipe.jsonAnimalID.equals(jsonAnimalID)) continue;
            inputIngredients.add(existingRecipe.inputStack);
            extraInputIngredients.add(existingRecipe.extraInputStack);
            outputIngredients.add(existingRecipe.resultItemStack);
            spawnEggs.add(existingRecipe.spawnEgg);
            existingRecipe.setInputIngredient(Utils.deduplicateIngredients(inputIngredients));
            existingRecipe.setExtraInputIngredient(Utils.deduplicateIngredients(extraInputIngredients));
            existingRecipe.setOutputIngredient(Utils.deduplicateIngredients(outputIngredients));
            existingRecipe.setSpawnEggs(Utils.deduplicateIngredients(spawnEggs));
            return existingRecipe;
        }
        boolean isTamed = mobData.has("tamed") && mobData.get("tamed").getAsBoolean();
        boolean isTrusting = mobData.has("trusting") && mobData.get("trusting").getAsBoolean();
        BreedingRecipe breedingRecipe = new BreedingRecipe(entityType, Utils.deduplicateIngredients(inputIngredients), Utils.deduplicateIngredients(spawnEggs), isTamed, Utils.deduplicateIngredients(outputIngredients), Utils.deduplicateIngredients(extraInputIngredients), isTrusting, jsonModID, jsonAnimalID, modFolder, fileName);
        JustEnoughBreeding.breedingRecipes.add(breedingRecipe);
        return breedingRecipe;
    }

    public static class_1856 deduplicateIngredients(List<class_1856> ingredientList) {
        class_1856 ingredient = Utils.merge(ingredientList);
        HashSet<JsonElement> seen = new HashSet<JsonElement>();
        ArrayList<JsonElement> uniqueJson = new ArrayList<JsonElement>();
        JsonElement json = ingredient.method_8089();
        if (json.isJsonArray()) {
            for (JsonElement el : json.getAsJsonArray()) {
                if (!seen.add(el)) continue;
                uniqueJson.add(el);
            }
        } else {
            seen.add(json);
            uniqueJson.add(json);
        }
        JsonArray result = new JsonArray();
        uniqueJson.forEach(arg_0 -> ((JsonArray)result).add(arg_0));
        return class_1856.method_52177((JsonElement)result);
    }
}

