/*
 * Decompiled with CFR 0.152.
 */
package com.christofmeg.justenoughbreeding.emi;

import com.christofmeg.justenoughbreeding.JustEnoughBreeding;
import com.christofmeg.justenoughbreeding.client.ClientUtils;
import com.christofmeg.justenoughbreeding.emi.AllayDuplicationCategoryEMI;
import com.christofmeg.justenoughbreeding.emi.BreedingCategoryEMI;
import com.christofmeg.justenoughbreeding.emi.TamingCategoryEMI;
import com.christofmeg.justenoughbreeding.emi.TemperCategoryEMI;
import com.christofmeg.justenoughbreeding.emi.TransformationCategoryEMI;
import com.christofmeg.justenoughbreeding.emi.TrustingCategoryEMI;
import com.christofmeg.justenoughbreeding.recipe.AllayDuplicationRecipe;
import com.christofmeg.justenoughbreeding.recipe.BaseRecipe;
import com.christofmeg.justenoughbreeding.recipe.BreedingRecipe;
import com.christofmeg.justenoughbreeding.recipe.TamingRecipe;
import com.christofmeg.justenoughbreeding.recipe.TemperRecipe;
import com.christofmeg.justenoughbreeding.recipe.TransformationRecipe;
import com.christofmeg.justenoughbreeding.recipe.TrustingRecipe;
import com.christofmeg.justenoughbreeding.utils.CommonClientUtils;
import dev.emi.emi.EmiPort;
import dev.emi.emi.EmiRenderHelper;
import dev.emi.emi.api.EmiRegistry;
import dev.emi.emi.api.render.EmiTexture;
import dev.emi.emi.api.widget.Bounds;
import dev.emi.emi.api.widget.Widget;
import dev.emi.emi.api.widget.WidgetHolder;
import java.util.ArrayList;
import java.util.Comparator;
import net.minecraft.class_1299;
import net.minecraft.class_1309;
import net.minecraft.class_1767;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_327;
import net.minecraft.class_332;
import net.minecraft.class_5250;
import org.jetbrains.annotations.NotNull;

public class EMIUtils {
    public static void registerRecipes(EmiRegistry registration) {
        ArrayList<AllayDuplicationRecipe> allayDuplicationRecipes = new ArrayList<AllayDuplicationRecipe>(registration.getRecipeManager().method_30027(JustEnoughBreeding.ALLAY_DUPLICATION_PROVIDER_TYPE));
        allayDuplicationRecipes.sort(Comparator.comparing(r -> r.jsonAnimalID == null ? "" : r.jsonAnimalID));
        for (AllayDuplicationRecipe allayDuplicationRecipe : allayDuplicationRecipes) {
            if (!JustEnoughBreeding.isModLoaded(allayDuplicationRecipe.jsonModID) || allayDuplicationRecipe.entityType == null || allayDuplicationRecipe.inputStack.method_8103()) continue;
            registration.addRecipe(AllayDuplicationCategoryEMI.builder().id(new class_2960("justenoughbreeding", "/allay_duplication/" + allayDuplicationRecipe.jsonModID + "/" + allayDuplicationRecipe.jsonAnimalID)).recipe(allayDuplicationRecipe).build());
        }
        ArrayList<BreedingRecipe> breedingRecipes = new ArrayList<BreedingRecipe>(registration.getRecipeManager().method_30027(JustEnoughBreeding.BREEDING_PROVIDER_TYPE));
        breedingRecipes.sort(Comparator.comparing(r -> r.jsonAnimalID == null ? "" : r.jsonAnimalID));
        for (BreedingRecipe breedingRecipe : breedingRecipes) {
            if (!JustEnoughBreeding.isModLoaded(breedingRecipe.jsonModID) || breedingRecipe.entityType == null || breedingRecipe.inputStack.method_8103()) continue;
            registration.addRecipe(BreedingCategoryEMI.builder().id(new class_2960("justenoughbreeding", "/breeding/" + breedingRecipe.jsonModID + "/" + breedingRecipe.jsonAnimalID)).recipe(breedingRecipe).build());
        }
        ArrayList<TamingRecipe> arrayList = new ArrayList<TamingRecipe>(registration.getRecipeManager().method_30027(JustEnoughBreeding.TAMING_PROVIDER_TYPE));
        arrayList.sort(Comparator.comparing(r -> r.jsonAnimalID == null ? "" : r.jsonAnimalID));
        for (TamingRecipe tamingRecipe : arrayList) {
            if (!JustEnoughBreeding.isModLoaded(tamingRecipe.jsonModID) || tamingRecipe.entityType == null || tamingRecipe.inputStack.method_8103()) continue;
            registration.addRecipe(TamingCategoryEMI.builder().id(new class_2960("justenoughbreeding", "/taming/" + tamingRecipe.jsonModID + "/" + tamingRecipe.jsonAnimalID)).recipe(tamingRecipe).build());
        }
        ArrayList<TemperRecipe> arrayList2 = new ArrayList<TemperRecipe>(registration.getRecipeManager().method_30027(JustEnoughBreeding.TEMPER_PROVIDER_TYPE));
        arrayList2.sort(Comparator.comparing(r -> r.jsonAnimalID == null ? "" : r.jsonAnimalID));
        for (TemperRecipe temperRecipe : arrayList2) {
            if (!JustEnoughBreeding.isModLoaded(temperRecipe.jsonModID) || temperRecipe.entityType == null || temperRecipe.inputStack.method_8103()) continue;
            registration.addRecipe(TemperCategoryEMI.builder().id(new class_2960("justenoughbreeding", "/temper/" + temperRecipe.jsonModID + "/" + temperRecipe.jsonAnimalID)).recipe(temperRecipe).build());
        }
        ArrayList<TransformationRecipe> arrayList3 = new ArrayList<TransformationRecipe>(registration.getRecipeManager().method_30027(JustEnoughBreeding.TRANSFORMATION_PROVIDER_TYPE));
        arrayList3.sort(Comparator.comparing(r -> r.outputEntityType == null ? r.fileName : r.outputEntityType.method_35050()));
        for (TransformationRecipe recipe : arrayList3) {
            if (!JustEnoughBreeding.isModLoaded(recipe.jsonModID) || recipe.inputEntityType == null || recipe.outputEntityType == null || recipe.inputStack.method_8103()) continue;
            registration.addRecipe(TransformationCategoryEMI.builder().id(new class_2960("justenoughbreeding", "/transformation/" + recipe.jsonModID + "/" + recipe.modFolder + "/" + recipe.fileName)).recipe(recipe).build());
        }
        ArrayList<TrustingRecipe> arrayList4 = new ArrayList<TrustingRecipe>(registration.getRecipeManager().method_30027(JustEnoughBreeding.TRUSTING_PROVIDER_TYPE));
        arrayList4.sort(Comparator.comparing(r -> r.jsonAnimalID == null ? "" : r.jsonAnimalID));
        for (TrustingRecipe recipe : arrayList4) {
            if (!JustEnoughBreeding.isModLoaded(recipe.jsonModID) || recipe.entityType == null || recipe.inputStack.method_8103()) continue;
            registration.addRecipe(TrustingCategoryEMI.builder().id(new class_2960("justenoughbreeding", "/trusting/" + recipe.jsonModID + "/" + recipe.jsonAnimalID)).recipe(recipe).build());
        }
    }

    public static void drawMobSlot(int mobSlotX, int mobSlotY, WidgetHolder widgets) {
        EmiTexture TOP = new EmiTexture(EmiRenderHelper.WIDGETS, 19, 0, 24, 1);
        EmiTexture CORNER = new EmiTexture(EmiRenderHelper.WIDGETS, 43, 0, 1, 1);
        EmiTexture LEFT = new EmiTexture(EmiRenderHelper.WIDGETS, 18, 0, 1, 25);
        EmiTexture RIGHT = new EmiTexture(EmiRenderHelper.WIDGETS, 43, 1, 1, 25);
        EmiTexture BOTTOM = new EmiTexture(EmiRenderHelper.WIDGETS, 19, 25, 25, 1);
        widgets.addTexture(TOP, mobSlotX + 2, mobSlotY + 1);
        widgets.addTexture(TOP, mobSlotX + 26, mobSlotY + 1);
        widgets.addTexture(new EmiTexture(EmiRenderHelper.WIDGETS, 19, 0, 11, 1), mobSlotX + 50, mobSlotY + 1);
        widgets.addTexture(CORNER, mobSlotX + 61, mobSlotY + 1);
        widgets.addTexture(LEFT, mobSlotX + 1, mobSlotY + 2);
        widgets.addTexture(LEFT, mobSlotX + 1, mobSlotY + 27);
        widgets.addTexture(LEFT, mobSlotX + 1, mobSlotY + 52);
        widgets.addTexture(LEFT, mobSlotX + 1, mobSlotY + 56);
        widgets.addTexture(RIGHT, mobSlotX + 61, mobSlotY + 2);
        widgets.addTexture(RIGHT, mobSlotX + 61, mobSlotY + 27);
        widgets.addTexture(RIGHT, mobSlotX + 61, mobSlotY + 52);
        widgets.addTexture(RIGHT, mobSlotX + 61, mobSlotY + 56);
        int color = CommonClientUtils.getPixelColor(new class_2960("emi", "textures/gui/widgets.png"), 30, 12);
        if (color == 0) {
            color = -7631989;
        }
        int startX = mobSlotX + 1;
        int startY = mobSlotY - 4;
        int width = 59;
        int height = 79;
        int finalColor = color;
        widgets.addDrawable(startX, startY, width, height, (guiGraphics, mouseX, mouseY, delta) -> guiGraphics.method_25294(startX, startY, startX + width, startY + height, finalColor));
        widgets.addTexture(CORNER, mobSlotX + 1, mobSlotY + 81);
        widgets.addTexture(BOTTOM, mobSlotX + 2, mobSlotY + 81);
        widgets.addTexture(BOTTOM, mobSlotX + 27, mobSlotY + 81);
        widgets.addTexture(BOTTOM, mobSlotX + 37, mobSlotY + 81);
    }

    public static void drawMobNameAndEntity(class_1299<?> entityType, WidgetHolder widgets, BaseRecipe recipe) {
        EMIUtils.drawMobNameAndEntity(entityType, widgets, recipe, 148, 0);
    }

    public static void drawMobNameAndEntity(class_1299<?> entityType, WidgetHolder widgets, BaseRecipe recipe, int availableWidth, int extraX) {
        EMIUtils.drawMobNameAndEntity(entityType, widgets, recipe, availableWidth, extraX, true, null);
    }

    public static void drawMobNameAndEntity(final class_1299<?> entityType, WidgetHolder widgets, final BaseRecipe recipe, int availableWidth, final int extraX, final boolean input, final class_1767 color) {
        if (entityType != null) {
            class_327 font = class_310.method_1551().field_1772;
            class_5250 entityName = class_2561.method_43471((String)entityType.method_5882());
            Object entityNameString = entityName.getString();
            if (recipe instanceof BreedingRecipe) {
                BreedingRecipe breedingRecipe = (BreedingRecipe)recipe;
                if (breedingRecipe.needsToBeTamed != null && breedingRecipe.needsToBeTamed.booleanValue()) {
                    tamed = class_2561.method_43471((String)"translation.justenoughbreeding.tamed");
                    entityNameString = (String)entityNameString + " (" + tamed.getString() + ")";
                } else if (breedingRecipe.animalTrusting != null && breedingRecipe.animalTrusting.booleanValue()) {
                    class_5250 trusting = class_2561.method_43471((String)"translation.justenoughbreeding.trusting");
                    entityNameString = (String)entityNameString + " (" + trusting.getString() + ")";
                } else if ("tfc".equals(breedingRecipe.jsonModID)) {
                    class_5250 familiarity = class_2561.method_43471((String)"tfc.jade.familiarity");
                    String tfc = familiarity.getString().replaceAll(":[^:]*$", "");
                    entityNameString = (String)entityNameString + " (" + tfc + " > 30)";
                }
            } else if (recipe instanceof TransformationRecipe) {
                TransformationRecipe transformationRecipe = (TransformationRecipe)recipe;
                if (input && transformationRecipe.needsToBeTamed != null && transformationRecipe.needsToBeTamed.booleanValue()) {
                    tamed = class_2561.method_43471((String)"translation.justenoughbreeding.tamed");
                    entityNameString = (String)entityNameString + " (" + tamed.getString() + ")";
                }
            }
            int stringWidth = font.method_1727((String)entityNameString);
            if (stringWidth > availableWidth) {
                float pixelWidthPerCharacter = (float)stringWidth / (float)Math.max(1, ((String)entityNameString).length());
                int maxCharacters = Math.max(0, (int)((float)availableWidth / pixelWidthPerCharacter));
                entityNameString = ((String)entityNameString).substring(0, Math.min(((String)entityNameString).length(), maxCharacters));
            }
            if (!((String)entityNameString).isEmpty()) {
                class_2561 abbreviatedEntityName = class_2561.method_30163((String)entityNameString);
                widgets.addText(EmiPort.ordered((class_2561)abbreviatedEntityName), extraX + 1, 1, -1, true);
            }
            widgets.add(new Widget(){

                public Bounds getBounds() {
                    return new Bounds(100, 0, 60, 80);
                }

                public void method_25394(@NotNull class_332 stack, int mouseX, int mouseY, float delta) {
                    class_1309 currentLivingEntity;
                    class_1309 class_13092 = currentLivingEntity = recipe instanceof TransformationRecipe ? ClientUtils.doRendering(entityType, input, color) : ClientUtils.doRendering(entityType);
                    if (currentLivingEntity != null) {
                        CommonClientUtils.renderEntity(stack.method_51448(), mouseX, currentLivingEntity, 31 + extraX, 89);
                    }
                }
            });
        }
    }
}

