/*
 * Decompiled with CFR 0.152.
 */
package com.christofmeg.justenoughbreeding.serializer;

import com.christofmeg.justenoughbreeding.JustEnoughBreeding;
import com.christofmeg.justenoughbreeding.recipe.TemperRecipe;
import com.christofmeg.justenoughbreeding.utils.CommonUtils;
import com.christofmeg.justenoughbreeding.utils.Utils;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import net.minecraft.class_1299;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1856;
import net.minecraft.class_1865;
import net.minecraft.class_2487;
import net.minecraft.class_2522;
import net.minecraft.class_2540;
import net.minecraft.class_2960;
import org.jetbrains.annotations.NotNull;

public class TemperSerializer
implements class_1865<TemperRecipe> {
    @NotNull
    public TemperRecipe fromJson(@NotNull class_2960 jsonPath, @NotNull JsonObject json) {
        JsonArray mobs = json.getAsJsonArray("mobs");
        JsonObject mobObject = mobs.get(0).getAsJsonObject();
        Map.Entry mobEntry = (Map.Entry)mobObject.entrySet().iterator().next();
        String jsonModID = json.get("mod").getAsString();
        String jsonAnimalID = (String)mobEntry.getKey();
        String modFolder = jsonPath.method_12836();
        String fileName = jsonPath.method_12832().substring(jsonPath.method_12832().lastIndexOf(47) + 1);
        if (jsonPath.method_12836().equals("justenoughbreeding")) {
            modFolder = jsonPath.method_12832().split("/")[1];
        }
        if (!JustEnoughBreeding.isModLoaded(modFolder) || !JustEnoughBreeding.isModLoaded(jsonModID)) {
            return new TemperRecipe.DummyRecipe(jsonModID, jsonAnimalID, modFolder, fileName);
        }
        class_1299<?> entityType = JustEnoughBreeding.getEntityFromLoaderRegistries(new class_2960(jsonModID, jsonAnimalID));
        if (entityType == null) {
            throw new JsonParseException("Unknown entity: " + jsonModID + ":" + jsonAnimalID + " in " + jsonPath);
        }
        ArrayList<class_1856> inputIngredients = new ArrayList<class_1856>();
        ArrayList<class_1856> extraInputIngredients = new ArrayList<class_1856>();
        ArrayList<class_1856> spawnEggs = new ArrayList<class_1856>();
        JsonObject mobData = ((JsonElement)mobEntry.getValue()).getAsJsonObject();
        this.addIngredients(mobData, inputIngredients, "inputs");
        this.addIngredients(mobData, extraInputIngredients, "extra_inputs");
        if (mobData.has("spawn_eggs")) {
            this.addIngredients(mobData, spawnEggs, "spawn_eggs");
        } else {
            class_1799 spawnEgg = Optional.ofNullable(JustEnoughBreeding.getSpawnEggItem(entityType)).map(class_1792::method_7854).orElse(class_1799.field_8037);
            spawnEggs = new ArrayList<class_1856>(List.of(class_1856.method_8101((class_1799[])new class_1799[]{spawnEgg})));
        }
        for (TemperRecipe existingRecipe : JustEnoughBreeding.temperRecipes) {
            if (!existingRecipe.jsonModID.equals(jsonModID) || !existingRecipe.jsonAnimalID.equals(jsonAnimalID)) continue;
            inputIngredients.add(existingRecipe.inputStack);
            spawnEggs.add(existingRecipe.spawnEgg);
            extraInputIngredients.add(existingRecipe.extraInputStack);
            existingRecipe.setInputIngredient(Utils.deduplicateIngredients(inputIngredients));
            existingRecipe.setExtraInputIngredient(Utils.deduplicateIngredients(extraInputIngredients));
            existingRecipe.setSpawnEggs(Utils.deduplicateIngredients(spawnEggs));
            return existingRecipe;
        }
        TemperRecipe r = new TemperRecipe(entityType, Utils.deduplicateIngredients(inputIngredients), Utils.deduplicateIngredients(spawnEggs), Utils.deduplicateIngredients(extraInputIngredients), jsonModID, jsonAnimalID, modFolder, fileName);
        JustEnoughBreeding.temperRecipes.add(r);
        return r;
    }

    @NotNull
    public TemperRecipe fromNetwork(@NotNull class_2960 id, @NotNull class_2540 buf) {
        class_2960 entityId = buf.method_10810();
        class_1299<?> entityType = JustEnoughBreeding.getEntityFromLoaderRegistries(entityId);
        if (entityType == null) {
            throw new JsonParseException("Unknown EntityType in TemperRecipe#fromNetwork: " + entityId);
        }
        class_1856 inputStack = class_1856.method_8086((class_2540)buf);
        class_1856 spawnEgg = class_1856.method_8086((class_2540)buf);
        boolean hasExtra = buf.readBoolean();
        class_1856 extraInputStack = hasExtra ? class_1856.method_8086((class_2540)buf) : class_1856.field_9017;
        String jsonModID = buf.method_19772();
        String jsonAnimalID = buf.method_19772();
        String modFolder = buf.method_19772();
        String fileName = buf.method_19772();
        return new TemperRecipe(entityType, inputStack, spawnEgg, extraInputStack, jsonModID, jsonAnimalID, modFolder, fileName);
    }

    public void toNetwork(@NotNull class_2540 buf, @NotNull TemperRecipe recipe) {
        class_2960 entityKey = JustEnoughBreeding.getKeyLoaderRegistries(recipe.entityType);
        if (entityKey == null) {
            throw new JsonParseException("Unknown EntityType in TemperRecipe: " + recipe.entityType);
        }
        buf.method_10812(entityKey);
        CommonUtils.safe(recipe.inputStack).method_8088(buf);
        CommonUtils.safe(recipe.spawnEgg).method_8088(buf);
        boolean hasExtra = recipe.extraInputStack != null && !recipe.extraInputStack.method_8103();
        buf.writeBoolean(hasExtra);
        if (hasExtra) {
            recipe.extraInputStack.method_8088(buf);
        }
        buf.method_10814(recipe.jsonModID);
        buf.method_10814(recipe.jsonAnimalID);
        buf.method_10814(recipe.modFolder);
        buf.method_10814(recipe.fileName);
    }

    private void addIngredients(JsonObject mobData, List<class_1856> ingredientList, String memberName) {
        if (mobData.has(memberName)) {
            for (JsonElement input : mobData.getAsJsonArray(memberName)) {
                class_2487 nbt = null;
                if (input.getAsJsonObject().has("nbt")) {
                    try {
                        nbt = class_2522.method_10718((String)input.getAsJsonObject().get("nbt").getAsString());
                    }
                    catch (CommandSyntaxException e) {
                        System.err.println("Invalid NBT data: {}" + input.getAsJsonObject().get("nbt").getAsString());
                    }
                }
                if (!input.getAsJsonObject().has("item")) continue;
                String ingredient = input.getAsJsonObject().get("item").getAsString();
                int temperValue = input.getAsJsonObject().has("value") ? input.getAsJsonObject().get("value").getAsInt() : 1;
                ingredientList.add(Utils.createCombinedIngredient(ingredient, temperValue, nbt));
            }
        }
    }
}

