/*
 * Decompiled with CFR 0.152.
 */
package com.christofmeg.justenoughbreeding.utils;

import com.christofmeg.justenoughbreeding.JustEnoughBreeding;
import com.christofmeg.justenoughbreeding.recipe.BreedingRecipe;
import com.christofmeg.justenoughbreeding.utils.CommonUtils;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderSet;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.level.ItemLike;
import org.jetbrains.annotations.Nullable;

public class Utils {
    public static List<Ingredient> createCombinedResultIngredients(String mobIngredients, int minCount, int maxCount) {
        String[] ingredientIds = mobIngredients.split(",");
        ArrayList<Ingredient> resultIngredients = new ArrayList<Ingredient>();
        ArrayList<Holder> combinedItemStacks = new ArrayList<Holder>();
        for (int count = minCount; count <= maxCount; ++count) {
            for (String ingredientId : ingredientIds) {
                ResourceLocation resourceLocation = ResourceLocation.tryParse((String)ingredientId.trim());
                Item ingredientItem = JustEnoughBreeding.getItemFromLoaderRegistries(resourceLocation);
                if (resourceLocation == null || ingredientItem == Items.AIR) continue;
                combinedItemStacks.add(new ItemStack((ItemLike)ingredientItem, count).getItemHolder());
            }
        }
        if (!combinedItemStacks.isEmpty()) {
            resultIngredients.add(Ingredient.of((HolderSet)HolderSet.direct(combinedItemStacks)));
        }
        return resultIngredients;
    }

    public static BreedingRecipe createBreedingRecipe(EntityType<?> entityType, Ingredient combinedIngredient, Item spawnEggItem, Boolean needsToBeTamed, @Nullable List<Ingredient> resultItemStacks, Boolean animalTrusting, @Nullable Ingredient combinedExtraIngredient) {
        if (resultItemStacks == null || resultItemStacks.isEmpty()) {
            return new BreedingRecipe(entityType, combinedIngredient, new ItemStack((ItemLike)spawnEggItem), needsToBeTamed, null, combinedExtraIngredient, animalTrusting);
        }
        ArrayList list = new ArrayList();
        for (Ingredient resultItemStack : resultItemStacks) {
            if (resultItemStack == null || resultItemStack.items().toList().isEmpty()) continue;
            list.addAll(resultItemStack.items().toList());
        }
        Ingredient mergedResultItemStacks = Ingredient.of((HolderSet)HolderSet.direct(list));
        return new BreedingRecipe(entityType, combinedIngredient, new ItemStack((ItemLike)spawnEggItem), needsToBeTamed, mergedResultItemStacks, combinedExtraIngredient, animalTrusting);
    }

    public static Ingredient createCombinedIngredient(String mobIngredients) {
        String[] ingredientIds = mobIngredients.split(",");
        ArrayList<Ingredient> combinedIngredients = new ArrayList<Ingredient>();
        for (String ingredientId : ingredientIds) {
            if (ingredientId.trim().startsWith("#")) {
                combinedIngredients.add(CommonUtils.createTagIngredient(ingredientId));
                continue;
            }
            Item ingredientItem = JustEnoughBreeding.getItemFromLoaderRegistries(ResourceLocation.parse((String)ingredientId.trim()));
            combinedIngredients.add(Ingredient.of((ItemLike)new ItemStack((ItemLike)ingredientItem).getItem()));
        }
        ArrayList list = new ArrayList();
        for (Ingredient resultItemStack : combinedIngredients) {
            list.addAll(resultItemStack.items().toList());
        }
        return Ingredient.of((HolderSet)HolderSet.direct(list));
    }
}

