/*
 * Decompiled with CFR 0.152.
 */
package net.davio.aquaticambitions.content.kinetics.fan.processing;

import com.simibubi.create.content.kinetics.fan.processing.FanProcessingType;
import com.simibubi.create.foundation.recipe.RecipeApplier;
import java.util.List;
import java.util.Optional;
import net.createmod.catnip.theme.Color;
import net.davio.aquaticambitions.content.kinetics.fan.processing.ChannelingRecipe;
import net.davio.aquaticambitions.content.processing.conduit.MechanicalConduitBlock;
import net.davio.aquaticambitions.content.processing.conduit.MechanicalConduitBlockEntity;
import net.davio.aquaticambitions.registry.CAARecipeTypes;
import net.davio.aquaticambitions.registry.CAATags;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.DustParticleOptions;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.util.RandomSource;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.ConduitBlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.Nullable;
import org.joml.Vector3f;

public class ChannelingFanProcessingType
implements FanProcessingType {
    private static final ChannelingRecipe.ChannelingWrapper CHANNELING_WRAPPER = new ChannelingRecipe.ChannelingWrapper();

    public boolean isValidAt(Level level, BlockPos pos) {
        if (this.checkForActiveConduit(level, pos)) {
            return true;
        }
        FluidState fluidState = level.m_6425_(pos);
        BlockState blockState = level.m_8055_(pos);
        return CAATags.CAABlockTags.FAN_PROCESSING_CATALYSTS_CHANNELING.matches(blockState) || CAATags.CAAFluidTags.FAN_PROCESSING_CATALYSTS_CHANNELING.matches(fluidState);
    }

    public int getPriority() {
        return 1200;
    }

    public boolean canProcess(ItemStack stack, Level level) {
        CHANNELING_WRAPPER.m_6836_(0, stack);
        Optional recipe = CAARecipeTypes.CHANNELING.find(CHANNELING_WRAPPER, level);
        return recipe.isPresent();
    }

    @Nullable
    public List<ItemStack> process(ItemStack stack, Level level) {
        CHANNELING_WRAPPER.m_6836_(0, stack);
        Optional recipe = CAARecipeTypes.CHANNELING.find(CHANNELING_WRAPPER, level);
        if (recipe.isPresent()) {
            return RecipeApplier.applyRecipeOn((Level)level, (ItemStack)stack, (Recipe)((Recipe)recipe.get()), (boolean)true);
        }
        return null;
    }

    public void spawnProcessingParticles(Level level, Vec3 pos) {
        if (level.f_46441_.m_188503_(8) != 0) {
            return;
        }
        Vector3f color = new Color(22015).asVectorF();
        level.m_7106_((ParticleOptions)new DustParticleOptions(color, 1.0f), pos.f_82479_ + (double)((level.f_46441_.m_188501_() - 0.5f) * 0.5f), pos.f_82480_ + 0.5, pos.f_82481_ + (double)((level.f_46441_.m_188501_() - 0.5f) * 0.5f), 0.0, 0.125, 0.0);
        if (level.f_46441_.m_188503_(8) < 2) {
            level.m_7106_((ParticleOptions)ParticleTypes.f_123775_, pos.f_82479_ + (double)((level.f_46441_.m_188501_() - 0.5f) * 0.5f), pos.f_82480_ + 0.5, pos.f_82481_ + (double)((level.f_46441_.m_188501_() - 0.5f) * 0.5f), (double)(level.f_46441_.m_188501_() - 0.5f), (double)(level.f_46441_.m_188501_() - 0.5f), (double)(level.f_46441_.m_188501_() - 0.5f));
        } else if (level.f_46441_.m_188503_(8) < 4) {
            level.m_7106_((ParticleOptions)ParticleTypes.f_123809_, pos.f_82479_ + (double)((level.f_46441_.m_188501_() - 0.5f) * 0.5f), pos.f_82480_ + 0.5, pos.f_82481_ + (double)((level.f_46441_.m_188501_() - 0.5f) * 0.5f), (double)(level.f_46441_.m_188501_() - 0.5f), (double)(level.f_46441_.m_188501_() - 0.5f), (double)(level.f_46441_.m_188501_() - 0.5f));
        }
    }

    public void morphAirFlow(FanProcessingType.AirFlowParticleAccess particleAccess, RandomSource random) {
        particleAccess.setColor(Color.mixColors((int)2070193, (int)22015, (float)random.m_188501_()));
        particleAccess.setAlpha(1.0f);
        if (random.m_188501_() < 0.00390625f) {
            particleAccess.spawnExtraParticle((ParticleOptions)ParticleTypes.f_123809_, 0.125f);
        }
        if (random.m_188501_() < 9.765625E-4f) {
            particleAccess.spawnExtraParticle((ParticleOptions)ParticleTypes.f_123775_, 0.075f);
        }
        if (random.m_188501_() < 0.015625f) {
            particleAccess.spawnExtraParticle((ParticleOptions)ParticleTypes.f_123795_, 0.125f);
        }
        if (random.m_188501_() < 0.015625f) {
            particleAccess.spawnExtraParticle((ParticleOptions)ParticleTypes.f_123772_, 0.125f);
        }
    }

    public boolean checkForActiveConduit(Level level, BlockPos pos) {
        for (int i = -1; i <= 1; ++i) {
            for (int j = -1; j <= 1; ++j) {
                for (int k = -1; k <= 1; ++k) {
                    BlockPos adjacentPos = pos.m_7918_(i, j, k);
                    BlockEntity blockEntity = level.m_7702_(adjacentPos);
                    if (!(blockEntity instanceof ConduitBlockEntity) || !((ConduitBlockEntity)blockEntity).m_59216_()) continue;
                    return true;
                }
            }
        }
        BlockEntity blockEntity = level.m_7702_(pos);
        if (blockEntity != null && blockEntity instanceof MechanicalConduitBlockEntity) {
            MechanicalConduitBlock.ConduitPowerLevel powerLevel = ((MechanicalConduitBlockEntity)blockEntity).getConduitLevelFromBlock();
            return powerLevel == MechanicalConduitBlock.ConduitPowerLevel.AWAKENED;
        }
        return false;
    }

    public void affectEntity(Entity entity, Level level) {
        if (level.f_46443_) {
            return;
        }
        if (entity instanceof Player) {
            ((Player)entity).m_7292_(new MobEffectInstance(MobEffects.f_19592_, 260, 0, true, true));
        }
    }
}

