/*
 * Decompiled with CFR 0.152.
 */
package com.coinflipex.plugin;

import com.coinflipex.plugin.commands.CommandHandler;
import com.coinflipex.plugin.listeners.ChatListener;
import com.coinflipex.plugin.listeners.GUIListener;
import com.coinflipex.plugin.managers.GUIManager;
import com.coinflipex.plugin.managers.GameManager;
import net.milkbowl.vault.economy.Economy;
import org.bukkit.command.CommandExecutor;
import org.bukkit.command.TabCompleter;
import org.bukkit.event.Listener;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.RegisteredServiceProvider;
import org.bukkit.plugin.java.JavaPlugin;

public class CoinFlipEX
extends JavaPlugin {
    private static CoinFlipEX instance;
    private Economy economy;
    private GameManager gameManager;
    private GUIManager guiManager;

    public void onEnable() {
        instance = this;
        this.saveDefaultConfig();
        if (!this.setupEconomy()) {
            this.getLogger().severe("Vault not found! Disabling plugin...");
            this.getServer().getPluginManager().disablePlugin((Plugin)this);
            return;
        }
        this.gameManager = new GameManager(this);
        this.guiManager = new GUIManager(this);
        CommandHandler commandHandler = new CommandHandler(this);
        this.getCommand("cf").setExecutor((CommandExecutor)commandHandler);
        this.getCommand("cf").setTabCompleter((TabCompleter)commandHandler);
        this.getCommand("cfadmin").setExecutor((CommandExecutor)commandHandler);
        this.getCommand("cfadmin").setTabCompleter((TabCompleter)commandHandler);
        this.getServer().getPluginManager().registerEvents((Listener)new GUIListener(this), (Plugin)this);
        this.getServer().getPluginManager().registerEvents((Listener)new ChatListener(this), (Plugin)this);
        this.getLogger().info("CoinFlipEX has been enabled!");
    }

    public void onDisable() {
        if (this.gameManager != null) {
            this.gameManager.cancelAllGames();
        }
        this.getLogger().info("CoinFlipEX has been disabled!");
    }

    private boolean setupEconomy() {
        if (this.getServer().getPluginManager().getPlugin("Vault") == null) {
            return false;
        }
        RegisteredServiceProvider rsp = this.getServer().getServicesManager().getRegistration(Economy.class);
        if (rsp == null) {
            return false;
        }
        this.economy = (Economy)rsp.getProvider();
        return this.economy != null;
    }

    public static CoinFlipEX getInstance() {
        return instance;
    }

    public Economy getEconomy() {
        return this.economy;
    }

    public GameManager getGameManager() {
        return this.gameManager;
    }

    public GUIManager getGUIManager() {
        return this.guiManager;
    }
}

