/*
 * Decompiled with CFR 0.152.
 */
package com.coinflipex.plugin.commands;

import com.coinflipex.plugin.CoinFlipEX;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.bukkit.ChatColor;
import org.bukkit.command.Command;
import org.bukkit.command.CommandExecutor;
import org.bukkit.command.CommandSender;
import org.bukkit.command.TabCompleter;
import org.bukkit.entity.Player;

public class CommandHandler
implements CommandExecutor,
TabCompleter {
    private final CoinFlipEX plugin;

    public CommandHandler(CoinFlipEX plugin) {
        this.plugin = plugin;
    }

    public boolean onCommand(CommandSender sender, Command command, String label, String[] args) {
        if (!(sender instanceof Player)) {
            sender.sendMessage(this.colorize("&cThis command can only be used by players!"));
            return true;
        }
        Player player = (Player)sender;
        if (command.getName().equalsIgnoreCase("cf") || command.getName().equalsIgnoreCase("cfex")) {
            if (!player.hasPermission("coinflipex.use")) {
                this.sendMessage(player, "&cYou don't have permission to use this command!");
                return true;
            }
            this.plugin.getGUIManager().openMainGUI(player);
            return true;
        }
        if (command.getName().equalsIgnoreCase("cfadmin")) {
            if (!player.hasPermission("coinflipex.admin")) {
                this.sendMessage(player, "&cYou don't have permission to use this command!");
                return true;
            }
            if (args.length == 0) {
                this.sendAdminHelp(player);
                return true;
            }
            if (args[0].equalsIgnoreCase("reload")) {
                this.plugin.reloadConfig();
                this.sendMessage(player, "&aConfiguration reloaded successfully!");
                return true;
            }
            if (args[0].equalsIgnoreCase("info")) {
                this.sendMessage(player, "&6CoinFlipEX v" + this.plugin.getDescription().getVersion());
                this.sendMessage(player, "&eActive games: &a" + this.plugin.getGameManager().getWaitingGames().size());
                return true;
            }
            this.sendAdminHelp(player);
            return true;
        }
        return false;
    }

    public List<String> onTabComplete(CommandSender sender, Command command, String alias, String[] args) {
        ArrayList<String> completions = new ArrayList<String>();
        if (command.getName().equalsIgnoreCase("cfadmin") && args.length == 1) {
            completions.addAll(Arrays.asList("reload", "info", "help"));
        }
        return completions;
    }

    private void sendAdminHelp(Player player) {
        this.sendMessage(player, "&6&lCoinFlipEX Admin Commands:");
        this.sendMessage(player, "&e/cfadmin reload &7- Reload configuration");
        this.sendMessage(player, "&e/cfadmin info &7- View plugin information");
        this.sendMessage(player, "&e/cfadmin help &7- Show this help message");
    }

    private void sendMessage(Player player, String message) {
        String prefix = this.plugin.getConfig().getString("messages.prefix", "&6[CoinFlipEX] &r");
        player.sendMessage(this.colorize(prefix + message));
    }

    private String colorize(String text) {
        return ChatColor.translateAlternateColorCodes((char)'&', (String)text);
    }
}

