/*
 * Decompiled with CFR 0.152.
 */
package com.coinflipex.plugin.listeners;

import com.coinflipex.plugin.CoinFlipEX;
import org.bukkit.ChatColor;
import org.bukkit.OfflinePlayer;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.Listener;
import org.bukkit.event.player.AsyncPlayerChatEvent;
import org.bukkit.plugin.Plugin;

public class ChatListener
implements Listener {
    private final CoinFlipEX plugin;

    public ChatListener(CoinFlipEX plugin) {
        this.plugin = plugin;
    }

    @EventHandler(priority=EventPriority.LOWEST)
    public void onPlayerChat(AsyncPlayerChatEvent event) {
        double amount;
        Player player = event.getPlayer();
        if (!this.plugin.getGameManager().hasPendingBet(player.getUniqueId())) {
            return;
        }
        event.setCancelled(true);
        String message = event.getMessage().trim();
        try {
            amount = Double.parseDouble(message);
        }
        catch (NumberFormatException e) {
            this.sendMessage(player, this.plugin.getConfig().getString("messages.invalid-amount"));
            return;
        }
        double minBet = this.plugin.getConfig().getDouble("economy.minimum-bet", 100.0);
        double maxBet = this.plugin.getConfig().getDouble("economy.maximum-bet", 1000000.0);
        if (amount < minBet) {
            this.sendMessage(player, this.plugin.getConfig().getString("messages.bet-too-low").replace("%min_bet%", String.valueOf(minBet)));
            return;
        }
        if (amount > maxBet) {
            this.sendMessage(player, this.plugin.getConfig().getString("messages.bet-too-high").replace("%max_bet%", String.valueOf(maxBet)));
            return;
        }
        double balance = this.plugin.getEconomy().getBalance((OfflinePlayer)player);
        if (balance < amount) {
            this.sendMessage(player, this.plugin.getConfig().getString("messages.insufficient-funds").replace("%player_balance%", String.valueOf(balance)).replace("%required_amount%", String.valueOf(amount)));
            this.plugin.getGameManager().removePendingBet(player.getUniqueId());
            return;
        }
        this.plugin.getEconomy().withdrawPlayer((OfflinePlayer)player, amount);
        this.plugin.getGameManager().setPendingBet(player.getUniqueId(), amount);
        this.plugin.getServer().getScheduler().runTask((Plugin)this.plugin, () -> this.plugin.getGUIManager().openGameModeGUI(player));
    }

    private void sendMessage(Player player, String message) {
        String prefix = this.plugin.getConfig().getString("messages.prefix", "&6[CoinFlipEX] &r");
        player.sendMessage(this.colorize(prefix + message));
    }

    private String colorize(String text) {
        return ChatColor.translateAlternateColorCodes((char)'&', (String)text);
    }
}

