/*
 * Decompiled with CFR 0.152.
 */
package com.coinflipex.plugin.listeners;

import com.coinflipex.plugin.CoinFlipEX;
import com.coinflipex.plugin.managers.CoinFlipAnimation;
import com.coinflipex.plugin.models.Game;
import java.util.List;
import org.bukkit.ChatColor;
import org.bukkit.OfflinePlayer;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.inventory.InventoryClickEvent;

public class GUIListener
implements Listener {
    private final CoinFlipEX plugin;

    public GUIListener(CoinFlipEX plugin) {
        this.plugin = plugin;
    }

    @EventHandler
    public void onInventoryClick(InventoryClickEvent event) {
        if (!(event.getWhoClicked() instanceof Player)) {
            return;
        }
        Player player = (Player)event.getWhoClicked();
        String title = event.getView().getTitle();
        String mainTitle = this.colorize(this.plugin.getConfig().getString("gui.title"));
        String modeTitle = this.colorize(this.plugin.getConfig().getString("gui.create-game-title"));
        String sideTitle = this.colorize(this.plugin.getConfig().getString("gui.side-selection-title"));
        if (!(title.equals(mainTitle) || title.equals(modeTitle) || title.equals(sideTitle))) {
            return;
        }
        event.setCancelled(true);
        if (event.getCurrentItem() == null || !event.getCurrentItem().hasItemMeta()) {
            return;
        }
        if (title.equals(mainTitle)) {
            this.handleMainGUIClick(player, event.getSlot());
        } else if (title.equals(modeTitle)) {
            this.handleModeGUIClick(player, event.getSlot());
        } else if (title.equals(sideTitle)) {
            this.handleSideGUIClick(player, event.getSlot());
        }
    }

    private void handleMainGUIClick(Player player, int slot) {
        if (slot == 53) {
            if (this.plugin.getGameManager().isPlayerInGame(player.getUniqueId())) {
                this.sendMessage(player, "&cYou are already in a game!");
                return;
            }
            player.closeInventory();
            this.sendMessage(player, this.plugin.getConfig().getString("messages.enter-amount"));
            this.plugin.getGameManager().setPendingBet(player.getUniqueId(), 0.0);
        } else if (slot < 53) {
            List<Game> waitingGames = this.plugin.getGameManager().getWaitingGames();
            if (slot >= waitingGames.size()) {
                return;
            }
            Game game = null;
            int index = 0;
            for (Game g : waitingGames) {
                if (g.getCreatorId().equals(player.getUniqueId())) continue;
                if (index == slot) {
                    game = g;
                    break;
                }
                ++index;
            }
            if (game == null) {
                return;
            }
            double balance = this.plugin.getEconomy().getBalance((OfflinePlayer)player);
            if (balance < game.getBetAmount()) {
                this.sendMessage(player, this.plugin.getConfig().getString("messages.insufficient-funds").replace("%player_balance%", String.valueOf(balance)).replace("%required_amount%", String.valueOf(game.getBetAmount())));
                return;
            }
            if (this.plugin.getGameManager().isPlayerInGame(player.getUniqueId())) {
                this.sendMessage(player, "&cYou are already in a game!");
                return;
            }
            this.plugin.getEconomy().withdrawPlayer((OfflinePlayer)player, game.getBetAmount());
            game.setOpponentId(player.getUniqueId());
            game.setOpponentName(player.getName());
            game.setStatus(Game.GameStatus.STARTING);
            player.closeInventory();
            this.sendMessage(player, this.plugin.getConfig().getString("messages.game-joined"));
            Player creator = this.plugin.getServer().getPlayer(game.getCreatorId());
            if (creator != null && creator.isOnline()) {
                this.sendMessage(creator, this.plugin.getConfig().getString("messages.game-starting"));
            }
            new CoinFlipAnimation(this.plugin, game).start();
        }
    }

    private void handleModeGUIClick(Player player, int slot) {
        if (slot == 11) {
            if (!this.plugin.getConfig().getBoolean("game-modes.player-vs-player.enabled", true)) {
                this.sendMessage(player, this.plugin.getConfig().getString("messages.pvp-disabled"));
                player.closeInventory();
                this.plugin.getGameManager().removePendingBet(player.getUniqueId());
                double pendingAmount = this.getPendingAmount(player);
                if (pendingAmount > 0.0) {
                    this.plugin.getEconomy().depositPlayer((OfflinePlayer)player, pendingAmount);
                }
                return;
            }
            this.plugin.getGameManager().setPendingMode(player.getUniqueId(), Game.GameMode.PLAYER_VS_PLAYER);
            this.plugin.getGUIManager().openSideSelectionGUI(player);
        } else if (slot == 15) {
            if (!this.plugin.getConfig().getBoolean("game-modes.ai-house.enabled", true)) {
                this.sendMessage(player, this.plugin.getConfig().getString("messages.ai-disabled"));
                player.closeInventory();
                this.plugin.getGameManager().removePendingBet(player.getUniqueId());
                double pendingAmount = this.getPendingAmount(player);
                if (pendingAmount > 0.0) {
                    this.plugin.getEconomy().depositPlayer((OfflinePlayer)player, pendingAmount);
                }
                return;
            }
            this.plugin.getGameManager().setPendingMode(player.getUniqueId(), Game.GameMode.AI_HOUSE);
            this.plugin.getGUIManager().openSideSelectionGUI(player);
        }
    }

    private void handleSideGUIClick(Player player, int slot) {
        Game.CoinSide side = null;
        if (slot == 11) {
            side = Game.CoinSide.HEADS;
        } else if (slot == 15) {
            side = Game.CoinSide.TAILS;
        }
        if (side == null) {
            return;
        }
        double amount = this.getPendingAmount(player);
        Game.GameMode mode = this.plugin.getGameManager().getPendingMode(player.getUniqueId());
        if (mode == null || amount <= 0.0) {
            player.closeInventory();
            return;
        }
        player.closeInventory();
        Game game = this.plugin.getGameManager().createGame(player.getUniqueId(), player.getName(), amount, mode, side);
        if (mode == Game.GameMode.AI_HOUSE) {
            if (game != null) {
                game.setStatus(Game.GameStatus.STARTING);
                this.sendMessage(player, this.plugin.getConfig().getString("messages.game-starting"));
                new CoinFlipAnimation(this.plugin, game).start();
            }
        } else {
            this.sendMessage(player, this.plugin.getConfig().getString("messages.game-created"));
        }
    }

    private double getPendingAmount(Player player) {
        return this.plugin.getGameManager().getPendingBet(player.getUniqueId());
    }

    private void sendMessage(Player player, String message) {
        String prefix = this.plugin.getConfig().getString("messages.prefix", "&6[CoinFlipEX] &r");
        player.sendMessage(this.colorize(prefix + message));
    }

    private String colorize(String text) {
        return ChatColor.translateAlternateColorCodes((char)'&', (String)text);
    }
}

