/*
 * Decompiled with CFR 0.152.
 */
package com.coinflipex.plugin.managers;

import com.coinflipex.plugin.CoinFlipEX;
import com.coinflipex.plugin.models.Game;
import java.text.DecimalFormat;
import java.util.Random;
import org.bukkit.ChatColor;
import org.bukkit.Location;
import org.bukkit.OfflinePlayer;
import org.bukkit.Particle;
import org.bukkit.Sound;
import org.bukkit.entity.Player;
import org.bukkit.plugin.Plugin;
import org.bukkit.scheduler.BukkitRunnable;

public class CoinFlipAnimation {
    private final CoinFlipEX plugin;
    private final Game game;
    private final Random random;
    private final DecimalFormat moneyFormat;

    public CoinFlipAnimation(CoinFlipEX plugin, Game game) {
        this.plugin = plugin;
        this.game = game;
        this.random = new Random();
        this.moneyFormat = new DecimalFormat("#,##0.00");
    }

    public void start() {
        this.game.setStatus(Game.GameStatus.IN_PROGRESS);
        final int duration = this.plugin.getConfig().getInt("animation.duration-seconds", 5);
        boolean playSound = this.plugin.getConfig().getBoolean("animation.play-sound", true);
        new BukkitRunnable(){
            int ticks = 0;
            final int maxTicks = duration * 20;

            public void run() {
                Player opponent;
                if (this.ticks >= this.maxTicks) {
                    CoinFlipAnimation.this.finishGame();
                    this.cancel();
                    return;
                }
                Player creator = CoinFlipAnimation.this.plugin.getServer().getPlayer(CoinFlipAnimation.this.game.getCreatorId());
                if (creator != null && creator.isOnline()) {
                    CoinFlipAnimation.this.playAnimationEffects(creator);
                }
                if (CoinFlipAnimation.this.game.getGameMode() == Game.GameMode.PLAYER_VS_PLAYER && CoinFlipAnimation.this.game.getOpponentId() != null && (opponent = CoinFlipAnimation.this.plugin.getServer().getPlayer(CoinFlipAnimation.this.game.getOpponentId())) != null && opponent.isOnline()) {
                    CoinFlipAnimation.this.playAnimationEffects(opponent);
                }
                this.ticks += 4;
            }
        }.runTaskTimer((Plugin)this.plugin, 0L, 4L);
    }

    private void playAnimationEffects(Player player) {
        if (!this.plugin.getConfig().getBoolean("animation.play-sound", true)) {
            return;
        }
        Location loc = player.getLocation().add(0.0, 2.0, 0.0);
        try {
            String particleName = this.plugin.getConfig().getString("animation.particle-effect", "FIREWORK_SPARK");
            Particle particle = Particle.valueOf((String)particleName);
            player.getWorld().spawnParticle(particle, loc, 5, 0.5, 0.5, 0.5, 0.1);
        }
        catch (IllegalArgumentException e) {
            player.getWorld().spawnParticle(Particle.FLAME, loc, 5, 0.5, 0.5, 0.5, 0.1);
        }
        try {
            String soundName = this.plugin.getConfig().getString("animation.sound-type", "ENTITY_EXPERIENCE_ORB_PICKUP");
            Sound sound = Sound.valueOf((String)soundName);
            float volume = (float)this.plugin.getConfig().getDouble("animation.sound-volume", 1.0);
            float pitch = (float)this.plugin.getConfig().getDouble("animation.sound-pitch", 1.0);
            player.playSound(player.getLocation(), sound, volume, pitch);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    private void finishGame() {
        Game.CoinSide result = this.determineResult();
        Player creator = this.plugin.getServer().getPlayer(this.game.getCreatorId());
        Player opponent = this.game.getOpponentId() != null ? this.plugin.getServer().getPlayer(this.game.getOpponentId()) : null;
        boolean creatorWon = result == this.game.getCreatorSide();
        double betAmount = this.game.getBetAmount();
        double totalPot = this.game.getGameMode() == Game.GameMode.PLAYER_VS_PLAYER ? betAmount * 2.0 : betAmount;
        double feePercentage = this.plugin.getConfig().getDouble("economy.server-fee-percentage", 5.0);
        double fee = totalPot * feePercentage / 100.0;
        double winnings = totalPot - fee;
        if (creatorWon) {
            if (creator != null && creator.isOnline()) {
                this.plugin.getEconomy().depositPlayer((OfflinePlayer)creator, winnings);
                this.sendMessage(creator, this.plugin.getConfig().getString("messages.you-won").replace("%winnings%", this.moneyFormat.format(winnings)).replace("%fee%", String.valueOf(feePercentage)));
            }
            if (opponent != null && opponent.isOnline()) {
                this.sendMessage(opponent, this.plugin.getConfig().getString("messages.you-lost").replace("%amount%", this.moneyFormat.format(betAmount)));
            }
            this.broadcastWinner(this.game.getCreatorName());
        } else {
            if (this.game.getGameMode() == Game.GameMode.PLAYER_VS_PLAYER && opponent != null && opponent.isOnline()) {
                this.plugin.getEconomy().depositPlayer((OfflinePlayer)opponent, winnings);
                this.sendMessage(opponent, this.plugin.getConfig().getString("messages.you-won").replace("%winnings%", this.moneyFormat.format(winnings)).replace("%fee%", String.valueOf(feePercentage)));
            }
            if (creator != null && creator.isOnline()) {
                this.sendMessage(creator, this.plugin.getConfig().getString("messages.you-lost").replace("%amount%", this.moneyFormat.format(betAmount)));
            }
            if (this.game.getGameMode() == Game.GameMode.PLAYER_VS_PLAYER) {
                this.broadcastWinner(this.game.getOpponentName());
            } else {
                this.broadcastWinner("The House");
            }
        }
        this.game.setStatus(Game.GameStatus.COMPLETED);
        this.plugin.getGameManager().removeGame(this.game.getGameId());
    }

    private Game.CoinSide determineResult() {
        double roll;
        double houseEdge;
        if (this.game.getGameMode() == Game.GameMode.AI_HOUSE && (houseEdge = this.plugin.getConfig().getDouble("game-modes.ai-house.house-edge-percentage", 0.0)) > 0.0 && (roll = this.random.nextDouble() * 100.0) < houseEdge) {
            return this.game.getCreatorSide() == Game.CoinSide.HEADS ? Game.CoinSide.TAILS : Game.CoinSide.HEADS;
        }
        return this.random.nextBoolean() ? Game.CoinSide.HEADS : Game.CoinSide.TAILS;
    }

    private void broadcastWinner(String winnerName) {
        Player opponent;
        String message = this.plugin.getConfig().getString("messages.opponent-won").replace("%winner%", winnerName);
        Player creator = this.plugin.getServer().getPlayer(this.game.getCreatorId());
        if (creator != null && creator.isOnline()) {
            this.sendMessage(creator, message);
        }
        if (this.game.getOpponentId() != null && (opponent = this.plugin.getServer().getPlayer(this.game.getOpponentId())) != null && opponent.isOnline()) {
            this.sendMessage(opponent, message);
        }
    }

    private void sendMessage(Player player, String message) {
        String prefix = this.plugin.getConfig().getString("messages.prefix", "&6[CoinFlipEX] &r");
        player.sendMessage(this.colorize(prefix + message));
    }

    private String colorize(String text) {
        return ChatColor.translateAlternateColorCodes((char)'&', (String)text);
    }
}

