/*
 * Decompiled with CFR 0.152.
 */
package com.coinflipex.plugin.managers;

import com.coinflipex.plugin.CoinFlipEX;
import com.coinflipex.plugin.models.Game;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.List;
import org.bukkit.Bukkit;
import org.bukkit.ChatColor;
import org.bukkit.Material;
import org.bukkit.OfflinePlayer;
import org.bukkit.entity.Player;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;

public class GUIManager {
    private final CoinFlipEX plugin;
    private final DecimalFormat moneyFormat;

    public GUIManager(CoinFlipEX plugin) {
        this.plugin = plugin;
        this.moneyFormat = new DecimalFormat("#,##0.00");
    }

    public void openMainGUI(Player player) {
        int rows = this.plugin.getConfig().getInt("gui.rows", 6);
        String title = this.colorize(this.plugin.getConfig().getString("gui.title", "&6&lCoinFlip Games"));
        Inventory gui = Bukkit.createInventory(null, (int)(rows * 9), (String)title);
        List<Game> waitingGames = this.plugin.getGameManager().getWaitingGames();
        double playerBalance = this.plugin.getEconomy().getBalance((OfflinePlayer)player);
        int slot = 0;
        for (Game game : waitingGames) {
            if (slot >= 53) break;
            if (game.getCreatorId().equals(player.getUniqueId())) continue;
            boolean canAfford = playerBalance >= game.getBetAmount();
            ItemStack item = this.createGameItem(game, canAfford);
            gui.setItem(slot, item);
            ++slot;
        }
        for (int i = slot; i < 53; ++i) {
            gui.setItem(i, this.createFillerItem());
        }
        gui.setItem(53, this.createCreateGameItem());
        player.openInventory(gui);
    }

    public void openGameModeGUI(Player player) {
        String title = this.colorize(this.plugin.getConfig().getString("gui.create-game-title", "&e&lSelect Game Mode"));
        Inventory gui = Bukkit.createInventory(null, (int)27, (String)title);
        for (int i = 0; i < 27; ++i) {
            gui.setItem(i, this.createFillerItem());
        }
        boolean pvpEnabled = this.plugin.getConfig().getBoolean("game-modes.player-vs-player.enabled", true);
        boolean aiEnabled = this.plugin.getConfig().getBoolean("game-modes.ai-house.enabled", true);
        if (pvpEnabled) {
            gui.setItem(11, this.createPlayerModeItem());
        }
        if (aiEnabled) {
            gui.setItem(15, this.createAIModeItem());
        }
        player.openInventory(gui);
    }

    public void openSideSelectionGUI(Player player) {
        String title = this.colorize(this.plugin.getConfig().getString("gui.side-selection-title", "&a&lChoose Your Side"));
        Inventory gui = Bukkit.createInventory(null, (int)27, (String)title);
        for (int i = 0; i < 27; ++i) {
            gui.setItem(i, this.createFillerItem());
        }
        gui.setItem(11, this.createHeadsItem());
        gui.setItem(15, this.createTailsItem());
        player.openInventory(gui);
    }

    private ItemStack createGameItem(Game game, boolean canAfford) {
        String materialName = canAfford ? this.plugin.getConfig().getString("gui-materials.active-game", "GOLD_INGOT") : this.plugin.getConfig().getString("gui-materials.active-game-cant-afford", "IRON_INGOT");
        Material material = this.getMaterial(materialName);
        ItemStack item = new ItemStack(material);
        ItemMeta meta = item.getItemMeta();
        String nameTemplate = canAfford ? this.plugin.getConfig().getString("gui-items.active-game.name", "&e%player%'s Game") : this.plugin.getConfig().getString("gui-items.active-game-cant-afford.name", "&e%player%'s Game");
        List loreTemplate = canAfford ? this.plugin.getConfig().getStringList("gui-items.active-game.lore") : this.plugin.getConfig().getStringList("gui-items.active-game-cant-afford.lore");
        meta.setDisplayName(this.colorize(nameTemplate.replace("%player%", game.getCreatorName())));
        ArrayList<String> lore = new ArrayList<String>();
        for (String line : loreTemplate) {
            lore.add(this.colorize(line.replace("%amount%", this.moneyFormat.format(game.getBetAmount())).replace("%side%", game.getCreatorSide().toString())));
        }
        meta.setLore(lore);
        item.setItemMeta(meta);
        return item;
    }

    private ItemStack createCreateGameItem() {
        String materialName = this.plugin.getConfig().getString("gui-materials.create-game", "EMERALD_BLOCK");
        Material material = this.getMaterial(materialName);
        ItemStack item = new ItemStack(material);
        ItemMeta meta = item.getItemMeta();
        String name = this.plugin.getConfig().getString("gui-items.create-game.name", "&a&lCreate New Game");
        List loreTemplate = this.plugin.getConfig().getStringList("gui-items.create-game.lore");
        meta.setDisplayName(this.colorize(name));
        ArrayList<String> lore = new ArrayList<String>();
        for (String line : loreTemplate) {
            lore.add(this.colorize(line));
        }
        meta.setLore(lore);
        item.setItemMeta(meta);
        return item;
    }

    private ItemStack createPlayerModeItem() {
        String materialName = this.plugin.getConfig().getString("gui-materials.player-mode", "DIAMOND");
        Material material = this.getMaterial(materialName);
        ItemStack item = new ItemStack(material);
        ItemMeta meta = item.getItemMeta();
        String name = this.plugin.getConfig().getString("gui-items.player-mode.name", "&e&lPlayer vs Player");
        List loreTemplate = this.plugin.getConfig().getStringList("gui-items.player-mode.lore");
        meta.setDisplayName(this.colorize(name));
        ArrayList<String> lore = new ArrayList<String>();
        for (String line : loreTemplate) {
            lore.add(this.colorize(line));
        }
        meta.setLore(lore);
        item.setItemMeta(meta);
        return item;
    }

    private ItemStack createAIModeItem() {
        String materialName = this.plugin.getConfig().getString("gui-materials.ai-mode", "REDSTONE_BLOCK");
        Material material = this.getMaterial(materialName);
        ItemStack item = new ItemStack(material);
        ItemMeta meta = item.getItemMeta();
        String name = this.plugin.getConfig().getString("gui-items.ai-mode.name", "&6&lAI / House");
        List loreTemplate = this.plugin.getConfig().getStringList("gui-items.ai-mode.lore");
        meta.setDisplayName(this.colorize(name));
        ArrayList<String> lore = new ArrayList<String>();
        for (String line : loreTemplate) {
            lore.add(this.colorize(line));
        }
        meta.setLore(lore);
        item.setItemMeta(meta);
        return item;
    }

    private ItemStack createHeadsItem() {
        String materialName = this.plugin.getConfig().getString("gui-materials.heads", "SUNFLOWER");
        Material material = this.getMaterial(materialName);
        ItemStack item = new ItemStack(material);
        ItemMeta meta = item.getItemMeta();
        String name = this.plugin.getConfig().getString("gui-items.heads.name", "&e&lHeads");
        List loreTemplate = this.plugin.getConfig().getStringList("gui-items.heads.lore");
        meta.setDisplayName(this.colorize(name));
        ArrayList<String> lore = new ArrayList<String>();
        for (String line : loreTemplate) {
            lore.add(this.colorize(line));
        }
        meta.setLore(lore);
        item.setItemMeta(meta);
        return item;
    }

    private ItemStack createTailsItem() {
        String materialName = this.plugin.getConfig().getString("gui-materials.tails", "DANDELION");
        Material material = this.getMaterial(materialName);
        ItemStack item = new ItemStack(material);
        ItemMeta meta = item.getItemMeta();
        String name = this.plugin.getConfig().getString("gui-items.tails.name", "&6&lTails");
        List loreTemplate = this.plugin.getConfig().getStringList("gui-items.tails.lore");
        meta.setDisplayName(this.colorize(name));
        ArrayList<String> lore = new ArrayList<String>();
        for (String line : loreTemplate) {
            lore.add(this.colorize(line));
        }
        meta.setLore(lore);
        item.setItemMeta(meta);
        return item;
    }

    private ItemStack createFillerItem() {
        String materialName = this.plugin.getConfig().getString("gui-materials.filler", "GRAY_STAINED_GLASS_PANE");
        Material material = this.getMaterial(materialName);
        ItemStack item = new ItemStack(material);
        ItemMeta meta = item.getItemMeta();
        String name = this.plugin.getConfig().getString("gui-items.filler.name", " ");
        meta.setDisplayName(this.colorize(name));
        item.setItemMeta(meta);
        return item;
    }

    private Material getMaterial(String name) {
        try {
            return Material.valueOf((String)name.toUpperCase());
        }
        catch (IllegalArgumentException e) {
            this.plugin.getLogger().warning("Invalid material: " + name + ", using STONE as fallback");
            return Material.STONE;
        }
    }

    private String colorize(String text) {
        return ChatColor.translateAlternateColorCodes((char)'&', (String)text);
    }
}

