/*
 * Decompiled with CFR 0.152.
 */
package com.coinflipex.plugin.managers;

import com.coinflipex.plugin.CoinFlipEX;
import com.coinflipex.plugin.models.Game;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import org.bukkit.OfflinePlayer;
import org.bukkit.entity.Player;

public class GameManager {
    private final CoinFlipEX plugin;
    private final Map<UUID, Game> activeGames;
    private final Map<UUID, Double> pendingBets;
    private final Map<UUID, Game.GameMode> pendingModes;

    public GameManager(CoinFlipEX plugin) {
        this.plugin = plugin;
        this.activeGames = new ConcurrentHashMap<UUID, Game>();
        this.pendingBets = new ConcurrentHashMap<UUID, Double>();
        this.pendingModes = new ConcurrentHashMap<UUID, Game.GameMode>();
    }

    public void setPendingBet(UUID playerId, double amount) {
        this.pendingBets.put(playerId, amount);
    }

    public boolean hasPendingBet(UUID playerId) {
        return this.pendingBets.containsKey(playerId);
    }

    public double getPendingBet(UUID playerId) {
        return this.pendingBets.getOrDefault(playerId, 0.0);
    }

    public void removePendingBet(UUID playerId) {
        this.pendingBets.remove(playerId);
    }

    public void setPendingMode(UUID playerId, Game.GameMode mode) {
        this.pendingModes.put(playerId, mode);
    }

    public Game.GameMode getPendingMode(UUID playerId) {
        return this.pendingModes.get(playerId);
    }

    public void removePendingMode(UUID playerId) {
        this.pendingModes.remove(playerId);
    }

    public Game createGame(UUID playerId, String playerName, double amount, Game.GameMode mode, Game.CoinSide side) {
        Game game = new Game(playerId, playerName, amount, mode, side);
        this.activeGames.put(game.getGameId(), game);
        this.removePendingBet(playerId);
        this.removePendingMode(playerId);
        return game;
    }

    public Game getGameByCreator(UUID playerId) {
        for (Game game : this.activeGames.values()) {
            if (!game.getCreatorId().equals(playerId) || game.getStatus() != Game.GameStatus.WAITING) continue;
            return game;
        }
        return null;
    }

    public List<Game> getWaitingGames() {
        ArrayList<Game> waitingGames = new ArrayList<Game>();
        for (Game game : this.activeGames.values()) {
            if (game.getStatus() != Game.GameStatus.WAITING || game.getGameMode() != Game.GameMode.PLAYER_VS_PLAYER) continue;
            waitingGames.add(game);
        }
        return waitingGames;
    }

    public Game getGame(UUID gameId) {
        return this.activeGames.get(gameId);
    }

    public void removeGame(UUID gameId) {
        this.activeGames.remove(gameId);
    }

    public void cancelAllGames() {
        for (Game game : new ArrayList<Game>(this.activeGames.values())) {
            Player creator;
            if (game.getStatus() != Game.GameStatus.WAITING || (creator = this.plugin.getServer().getPlayer(game.getCreatorId())) == null || !creator.isOnline()) continue;
            this.plugin.getEconomy().depositPlayer((OfflinePlayer)creator, game.getBetAmount());
        }
        this.activeGames.clear();
        for (Map.Entry entry : this.pendingBets.entrySet()) {
            Player player = this.plugin.getServer().getPlayer((UUID)entry.getKey());
            if (player == null || !player.isOnline()) continue;
            this.plugin.getEconomy().depositPlayer((OfflinePlayer)player, ((Double)entry.getValue()).doubleValue());
        }
        this.pendingBets.clear();
        this.pendingModes.clear();
    }

    public boolean isPlayerInGame(UUID playerId) {
        for (Game game : this.activeGames.values()) {
            if (!game.getCreatorId().equals(playerId) && (game.getOpponentId() == null || !game.getOpponentId().equals(playerId)) || game.getStatus() == Game.GameStatus.COMPLETED || game.getStatus() == Game.GameStatus.CANCELLED) continue;
            return true;
        }
        return false;
    }
}

