/*
 * Decompiled with CFR 0.152.
 */
package com.coinflipex.plugin.models;

import java.util.UUID;

public class Game {
    private final UUID gameId = UUID.randomUUID();
    private final UUID creatorId;
    private final String creatorName;
    private final double betAmount;
    private final GameMode gameMode;
    private final CoinSide creatorSide;
    private UUID opponentId;
    private String opponentName;
    private GameStatus status;
    private long createdTime;

    public Game(UUID creatorId, String creatorName, double betAmount, GameMode gameMode, CoinSide creatorSide) {
        this.creatorId = creatorId;
        this.creatorName = creatorName;
        this.betAmount = betAmount;
        this.gameMode = gameMode;
        this.creatorSide = creatorSide;
        this.status = GameStatus.WAITING;
        this.createdTime = System.currentTimeMillis();
    }

    public UUID getGameId() {
        return this.gameId;
    }

    public UUID getCreatorId() {
        return this.creatorId;
    }

    public String getCreatorName() {
        return this.creatorName;
    }

    public double getBetAmount() {
        return this.betAmount;
    }

    public GameMode getGameMode() {
        return this.gameMode;
    }

    public CoinSide getCreatorSide() {
        return this.creatorSide;
    }

    public UUID getOpponentId() {
        return this.opponentId;
    }

    public void setOpponentId(UUID opponentId) {
        this.opponentId = opponentId;
    }

    public String getOpponentName() {
        return this.opponentName;
    }

    public void setOpponentName(String opponentName) {
        this.opponentName = opponentName;
    }

    public GameStatus getStatus() {
        return this.status;
    }

    public void setStatus(GameStatus status) {
        this.status = status;
    }

    public long getCreatedTime() {
        return this.createdTime;
    }

    public CoinSide getOpponentSide() {
        return this.creatorSide == CoinSide.HEADS ? CoinSide.TAILS : CoinSide.HEADS;
    }

    public static enum GameMode {
        PLAYER_VS_PLAYER,
        AI_HOUSE;

    }

    public static enum CoinSide {
        HEADS,
        TAILS;

    }

    public static enum GameStatus {
        WAITING,
        STARTING,
        IN_PROGRESS,
        COMPLETED,
        CANCELLED;

    }
}

