package com.github.thedeathlycow.thermoo.api;

import com.github.thedeathlycow.thermoo.api.environment.EnvironmentDefinition;
import com.github.thedeathlycow.thermoo.api.environment.provider.EnvironmentProvider;
import com.github.thedeathlycow.thermoo.api.environment.provider.EnvironmentProviderType;
import com.github.thedeathlycow.thermoo.api.temperature.effects.TemperatureEffect;
import com.github.thedeathlycow.thermoo.impl.Thermoo;
import net.minecraft.class_2378;
import net.minecraft.class_5321;
import net.minecraft.class_9331;

public final class ThermooRegistryKeys {
    /**
     * Key for the temperature effect registry
     * <p>
     * Note that the datapack registry for temperature effects is defined by a {@link com.github.thedeathlycow.thermoo.api.temperature.effects.ConfiguredTemperatureEffect}
     *
     * @see TemperatureEffect
     */
    public static final class_5321<class_2378<TemperatureEffect<?>>> TEMPERATURE_EFFECT = createRegistryKey("temperature_effects");

    /**
     * The key for the environment component type registry
     *
     * @see com.github.thedeathlycow.thermoo.api.environment.component.EnvironmentComponentTypes
     */
    public static final class_5321<class_2378<class_9331<?>>> ENVIRONMENT_COMPONENT_TYPE = createRegistryKey("environment_component_type");

    /**
     * Key for the environment provider type registry
     *
     * @see EnvironmentProviderType
     */
    public static final class_5321<class_2378<EnvironmentProviderType<?>>> ENVIRONMENT_PROVIDER_TYPE = createRegistryKey("environment_provider_type");

    /**
     * Key for the environment provider registry.
     * <p>
     * This registry is a dynamic registry, with elements defined from a datapack in the folder {@code /thermoo/environment_provider/}
     *
     * @see EnvironmentProvider
     */
    public static final class_5321<class_2378<EnvironmentProvider>> ENVIRONMENT_PROVIDER = createRegistryKey("environment_provider");

    /**
     * Key for the environment definition registry
     * <p>
     * This registry is a dynamic registry, with elements defined from a datapack in the folder {@code /thermoo/environment/}
     *
     * @see EnvironmentDefinition
     */
    public static final class_5321<class_2378<EnvironmentDefinition>> ENVIRONMENT = createRegistryKey("environment");

    private static <T> class_5321<class_2378<T>> createRegistryKey(String registryId) {
        return class_5321.method_29180(Thermoo.id(registryId));
    }

    private ThermooRegistryKeys() {

    }
}
