package com.github.thedeathlycow.thermoo.api.predicate;

import com.github.thedeathlycow.thermoo.api.temperature.Soakable;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import net.minecraft.class_1297;
import net.minecraft.class_181;
import net.minecraft.class_2096;
import net.minecraft.class_47;
import net.minecraft.class_5341;
import net.minecraft.class_5342;

/**
 * Loot condition used to test the soaking values of an entity in a predicate. Only works for entities that implement
 * {@link Soakable}, which by default is only {@link net.minecraft.class_1309}. All other entities will return
 * always false.
 *
 * @param value The {@linkplain Soakable#thermoo$getWetTicks() soaking value}
 * @param scale The {@linkplain Soakable#thermoo$getSoakedScale() soaking scale}
 */
public record SoakedLootCondition(
        class_2096.class_2100 value,
        class_2096.class_2099 scale
) implements class_5341 {

    public static final MapCodec<SoakedLootCondition> CODEC = RecordCodecBuilder.mapCodec(
            instance -> instance.group(
                    class_2096.class_2100.field_45763
                            .fieldOf("value")
                            .orElse(class_2096.class_2100.field_9708)
                            .forGetter(SoakedLootCondition::value),
                    class_2096.class_2099.field_45762
                            .fieldOf("scale")
                            .orElse(class_2096.class_2099.field_9705)
                            .forGetter(SoakedLootCondition::scale)
            ).apply(instance, SoakedLootCondition::new)
    );

    @Override
    public class_5342 method_29325() {
        return ThermooLootConditionTypes.SOAKED;
    }

    @Override
    public boolean test(class_47 lootContext) {
        class_1297 entity = lootContext.method_65013(class_181.field_1226);
        if (entity instanceof Soakable soakable) {
            return this.value.method_9054(soakable.thermoo$getWetTicks())
                    && this.scale.method_9047(soakable.thermoo$getSoakedScale());
        }

        return false;
    }

    public static class_5341.class_210 builder(class_2096.class_2100 value) {
        return () -> new SoakedLootCondition(value, class_2096.class_2099.field_9705);
    }

    public static class_5341.class_210 builder(class_2096.class_2099 scale) {
        return () -> new SoakedLootCondition(class_2096.class_2100.field_9708, scale);
    }
}
