package com.github.thedeathlycow.thermoo.impl.temperature.effect;

import com.github.thedeathlycow.thermoo.api.ThermooRegistryKeys;
import com.github.thedeathlycow.thermoo.api.temperature.effects.ConfiguredTemperatureEffect;
import com.github.thedeathlycow.thermoo.impl.Thermoo;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.JsonOps;
import net.fabricmc.fabric.api.resource.SimpleSynchronousResourceReloadListener;
import net.fabricmc.fabric.api.resource.conditions.v1.ResourceCondition;
import net.fabricmc.fabric.api.resource.conditions.v1.ResourceConditions;
import net.minecraft.class_1299;
import net.minecraft.class_2960;
import net.minecraft.class_3298;
import net.minecraft.class_3300;
import net.minecraft.class_5321;
import net.minecraft.class_6903;
import net.minecraft.class_7225;
import net.minecraft.class_7654;
import net.minecraft.class_7924;
import java.io.BufferedReader;
import java.util.*;

public class TemperatureEffectLoader implements SimpleSynchronousResourceReloadListener {

    public static final String DIRECTORY = "thermoo/temperature_effect";
    public static final class_2960 ID = Thermoo.id("temperature_effects");

    private final Map<class_2960, ConfiguredTemperatureEffect<?>> globalEffects = new HashMap<>();

    private final Map<class_5321<class_1299<?>>, Set<ConfiguredTemperatureEffect<?>>> entityTypeToEffect = new IdentityHashMap<>();

    private final class_6903<JsonElement> ops;

    public TemperatureEffectLoader(class_7225.class_7874 lookup) {
        this.ops = class_6903.method_46632(JsonOps.INSTANCE, lookup);
    }

    @Override
    public class_2960 getFabricId() {
        return ID;
    }

    @Override
    public void method_14491(class_3300 manager) {
        Map<class_2960, ConfiguredTemperatureEffect<?>> updatedRegistry = new HashMap<>();
        class_7654 resourceFinder = class_7654.method_45114(DIRECTORY);
        Map<class_2960, List<class_3298>> foundResources = resourceFinder.method_45116(manager);

        for (Map.Entry<class_2960, List<class_3298>> allResources : foundResources.entrySet()) {
            class_2960 effectID = resourceFinder.method_45115(allResources.getKey());
            for (class_3298 resource : allResources.getValue()) {
                try (BufferedReader reader = resource.method_43039()) {
                    this.loadEffect(updatedRegistry, effectID, reader);
                } catch (Exception e) {
                    Thermoo.LOGGER.error("An error occurred while loading temperature effect {}: {}", allResources.getKey(), e);
                }
            }
        }

        TemperatureEffectManager.INSTANCE.updateRegistry(updatedRegistry);
    }

    private void loadEffect(
            Map<class_2960, ConfiguredTemperatureEffect<?>> updatedRegistry,
            class_2960 id,
            BufferedReader reader
    ) {
        JsonElement json = JsonParser.parseReader(reader);
        if (json.isJsonObject() && this.objectMatchesConditions(id, json.getAsJsonObject())) {
            ConfiguredTemperatureEffect<?> effect = ConfiguredTemperatureEffect.CODEC.decode(this.ops, json)
                    .getOrThrow()
                    .getFirst();

            boolean overridden = false;
            if (updatedRegistry.containsKey(id)) {
                ConfiguredTemperatureEffect<?> existingEffect = updatedRegistry.get(id);
                if (existingEffect.loadingPriority() > effect.loadingPriority()) {
                    overridden = true;
                }
            }

            if (!overridden) {
                updatedRegistry.put(id, effect);
            } else {
                Thermoo.LOGGER.debug("Temperature Effect {} tried to load, but was overridden by a higher priority effect with the same ID.", id);
            }
        } else {
            Thermoo.LOGGER.debug("Temperature Effect {} not loaded, as its resource conditions were not met.", id);
        }
    }

    private boolean objectMatchesConditions(class_2960 key, JsonObject json) {
        if (json.has(ResourceConditions.CONDITIONS_KEY)) {
            DataResult<ResourceCondition> conditions = ResourceCondition.CONDITION_CODEC.parse(
                    JsonOps.INSTANCE,
                    json.get(ResourceConditions.CONDITIONS_KEY)
            );

            if (conditions.isSuccess()) {
                boolean matched = conditions.getOrThrow().test(null);

                if (Thermoo.LOGGER.isDebugEnabled()) {
                    String verdict = matched ? "Allowed" : "Rejected";
                    Thermoo.LOGGER.debug(
                            "{} resource of type {} with id {}",
                            verdict,
                            class_7924.method_60915(ThermooRegistryKeys.TEMPERATURE_EFFECT),
                            key
                    );
                }

                return matched;
            } else {
                Thermoo.LOGGER.error(
                        "Failed to parse resource conditions for file of type {} with id {}, skipping: {}",
                        class_7924.method_60915(ThermooRegistryKeys.TEMPERATURE_EFFECT),
                        key,
                        conditions.error().get().message()
                );
            }
        }

        return true;
    }
}
