package com.github.thedeathlycow.thermoo.mixin.client;

import com.github.thedeathlycow.thermoo.api.client.StatusBarOverlayRenderEvents;
import com.github.thedeathlycow.thermoo.impl.client.HeartBarContextImpl;
import com.llamalad7.mixinextras.sugar.Local;
import com.llamalad7.mixinextras.sugar.Share;
import com.llamalad7.mixinextras.sugar.ref.LocalRef;
import org.jetbrains.annotations.Nullable;
import org.joml.Vector2i;
import org.spongepowered.asm.mixin.Debug;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

import java.util.ArrayList;
import java.util.Collections;
import java.util.SequencedCollection;
import net.minecraft.class_1309;
import net.minecraft.class_1657;
import net.minecraft.class_329;
import net.minecraft.class_332;
import net.minecraft.class_3532;

/**
 * For the mount health bar. For the player health bar see {@link InGameHudPlayerTemperatureMixin}
 */
@Mixin(class_329.class)
@Debug(export = true)
public abstract class InGameHudMountTemperatureMixin {
    @Shadow
    protected abstract class_1309 getRiddenEntity();

    @Shadow
    protected abstract class_1657 getCameraPlayer();

    @Shadow
    protected abstract int getHeartCount(@Nullable class_1309 entity);

    @Inject(
            method = "renderMountHealth",
            at = @At(
                    value = "INVOKE",
                    target = "Lnet/minecraft/client/gui/DrawContext;drawGuiTexture(Lcom/mojang/blaze3d/pipeline/RenderPipeline;Lnet/minecraft/util/Identifier;IIII)V",
                    ordinal = 0
            )
    )
    private void startHeartCapture(
            class_332 context,
            CallbackInfo ci,
            @Local(ordinal = 8) int heartX,
            @Local(ordinal = 4) int heartY,
            @Share("thermoo_heart_positions") LocalRef<SequencedCollection<Vector2i>> heartPositionsRef
    ) {
        if (heartPositionsRef.get() == null) {
            heartPositionsRef.set(new ArrayList<>());
        }

        heartPositionsRef.get().add(new Vector2i(heartX, heartY));
    }

    @Inject(
            method = "renderMountHealth",
            at = @At("TAIL")
    )
    private void renderMountHealth(
            class_332 context,
            CallbackInfo ci,
            @Share("thermoo_heart_positions") LocalRef<SequencedCollection<Vector2i>> heartPositionsRef
    ) {
        SequencedCollection<Vector2i> heartPositions = heartPositionsRef.get();
        if (heartPositions == null) {
            return;
        }

        class_1657 player = this.getCameraPlayer();
        class_1309 mount = this.getRiddenEntity();

        // this weirdness accounts for two vanilla bugs:
        // - MC-200102: last half heart is not displayed with an odd max health
        // - a second bug that only shows up to 3 rows of mount health
        int maxHealth = this.getHeartCount(mount) * 2;
        int health = Math.min(class_3532.method_15386(mount.method_6032()), maxHealth);

        var heartBarContext = new HeartBarContextImpl(
                Collections.unmodifiableSequencedCollection(heartPositions),
                health,
                maxHealth
        );

        StatusBarOverlayRenderEvents.AFTER_MOUNT_HEALTH_BAR.invoker().render(context, player, mount, heartBarContext);
    }
}
