/*
 * Decompiled with CFR 0.152.
 */
package com.github.thedeathlycow.thermoo.api.environment.provider;

import com.github.thedeathlycow.thermoo.api.environment.provider.EnvironmentProvider;
import com.github.thedeathlycow.thermoo.api.environment.provider.EnvironmentProviderType;
import com.github.thedeathlycow.thermoo.api.environment.provider.EnvironmentProviderTypes;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.Keyable;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.Collections;
import java.util.EnumMap;
import java.util.Map;
import java.util.Objects;
import net.minecraft.class_1937;
import net.minecraft.class_1959;
import net.minecraft.class_2338;
import net.minecraft.class_3542;
import net.minecraft.class_6880;
import net.minecraft.class_9323;
import org.jetbrains.annotations.Contract;

public final class BiomePrecipitationTypeEnvironmentProvider
implements EnvironmentProvider {
    public static final MapCodec<BiomePrecipitationTypeEnvironmentProvider> CODEC = RecordCodecBuilder.mapCodec(instance -> instance.group((App)BiomePrecipitationTypeEnvironmentProvider.createPrecipitationMapCodec().fieldOf("precipitation_type").forGetter(BiomePrecipitationTypeEnvironmentProvider::precipitationType)).apply((Applicative)instance, BiomePrecipitationTypeEnvironmentProvider::new));
    private final Map<class_1959.class_1963, class_6880<EnvironmentProvider>> precipitationTypeMap = new EnumMap<class_1959.class_1963, class_6880<EnvironmentProvider>>(class_1959.class_1963.class);

    private BiomePrecipitationTypeEnvironmentProvider(Map<class_1959.class_1963, class_6880<EnvironmentProvider>> precipitationTypeMap) {
        this.precipitationTypeMap.putAll(precipitationTypeMap);
    }

    @Override
    public void buildCurrentComponents(class_1937 level, class_2338 pos, class_6880<class_1959> biome, class_9323.class_9324 builder) {
        class_1959.class_1963 biomePrecipitationType = ((class_1959)biome.comp_349()).method_48162(pos, level.method_8615());
        class_6880<EnvironmentProvider> provider = this.precipitationTypeMap.get(biomePrecipitationType);
        if (provider != null) {
            ((EnvironmentProvider)provider.comp_349()).buildCurrentComponents(level, pos, biome, builder);
        }
    }

    public EnvironmentProviderType<BiomePrecipitationTypeEnvironmentProvider> getType() {
        return EnvironmentProviderTypes.PRECIPITATION_TYPE;
    }

    public Map<class_1959.class_1963, class_6880<EnvironmentProvider>> precipitationType() {
        return Collections.unmodifiableMap(this.precipitationTypeMap);
    }

    private static MapCodec<Map<class_1959.class_1963, class_6880<EnvironmentProvider>>> createPrecipitationMapCodec() {
        return Codec.simpleMap((Codec)class_1959.class_1963.field_46251, EnvironmentProvider.HOLDER_CODEC, (Keyable)class_3542.method_28142((class_3542[])class_1959.class_1963.values())).validate(map -> {
            if (map.isEmpty()) {
                return DataResult.error(() -> "No precipitation key in: " + String.valueOf(map));
            }
            return DataResult.success((Object)map);
        });
    }

    public static final class Builder {
        private final Map<class_1959.class_1963, class_6880<EnvironmentProvider>> precipitationMap = new EnumMap<class_1959.class_1963, class_6880<EnvironmentProvider>>(class_1959.class_1963.class);

        private Builder() {
        }

        @Contract(value="_,_->this")
        public Builder addChild(class_1959.class_1963 precipitation, class_6880<EnvironmentProvider> child) {
            Objects.requireNonNull(precipitation);
            Objects.requireNonNull(child);
            this.precipitationMap.put(precipitation, child);
            return this;
        }

        @Contract(value="->new")
        public BiomePrecipitationTypeEnvironmentProvider build() {
            if (this.precipitationMap.keySet().isEmpty()) {
                throw new IllegalArgumentException("Precipitation map requires at least one key!");
            }
            return new BiomePrecipitationTypeEnvironmentProvider(this.precipitationMap);
        }
    }
}

