/*
 * Decompiled with CFR 0.152.
 */
package com.github.thedeathlycow.thermoo.api.environment.provider;

import com.github.thedeathlycow.thermoo.api.environment.component.EnvironmentComponentTypes;
import com.github.thedeathlycow.thermoo.api.environment.component.TemperatureRecordComponent;
import com.github.thedeathlycow.thermoo.api.environment.provider.EnvironmentProvider;
import com.github.thedeathlycow.thermoo.api.environment.provider.EnvironmentProviderType;
import com.github.thedeathlycow.thermoo.api.environment.provider.EnvironmentProviderTypes;
import com.github.thedeathlycow.thermoo.api.util.TemperatureRecord;
import com.github.thedeathlycow.thermoo.impl.Thermoo;
import com.github.thedeathlycow.thermoo.mixin.common.accessor.ComponentMapBuilderAccessor;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import net.minecraft.class_1937;
import net.minecraft.class_1959;
import net.minecraft.class_2338;
import net.minecraft.class_6880;
import net.minecraft.class_9323;
import org.jetbrains.annotations.Contract;

public final class TemperatureShiftEnvironmentProvider
implements EnvironmentProvider {
    public static final MapCodec<TemperatureShiftEnvironmentProvider> CODEC = RecordCodecBuilder.mapCodec(instance -> instance.group((App)TemperatureRecord.CODEC.fieldOf("shift").forGetter(TemperatureShiftEnvironmentProvider::shift)).apply((Applicative)instance, TemperatureShiftEnvironmentProvider::new));
    private final TemperatureRecord shift;

    private TemperatureShiftEnvironmentProvider(TemperatureRecord shift) {
        this.shift = shift;
    }

    @Contract(value="_->new")
    public static TemperatureShiftEnvironmentProvider create(TemperatureRecord shift) {
        return new TemperatureShiftEnvironmentProvider(shift);
    }

    @Override
    public void buildCurrentComponents(class_1937 level, class_2338 pos, class_6880<class_1959> biome, class_9323.class_9324 builder) {
        ComponentMapBuilderAccessor accessor = (ComponentMapBuilderAccessor)builder;
        if (builder.contains(EnvironmentComponentTypes.TEMPERATURE)) {
            TemperatureRecord base = (TemperatureRecord)builder.getOrDefault(EnvironmentComponentTypes.TEMPERATURE, (Object)TemperatureRecordComponent.DEFAULT);
            TemperatureRecord shifted = base.add(this.shift);
            builder.method_57840(EnvironmentComponentTypes.TEMPERATURE, (Object)shifted);
        } else {
            Thermoo.LOGGER.warn("Unable to shift a missing temperature component in: {}", accessor.thermoo$getMap());
        }
    }

    public EnvironmentProviderType<TemperatureShiftEnvironmentProvider> getType() {
        return EnvironmentProviderTypes.TEMPERATURE_SHIFT;
    }

    public TemperatureRecord shift() {
        return this.shift;
    }
}

