/*
 * Decompiled with CFR 0.152.
 */
package com.github.thedeathlycow.thermoo.api.environment.provider;

import com.github.thedeathlycow.thermoo.api.environment.provider.EnvironmentProvider;
import com.github.thedeathlycow.thermoo.api.environment.provider.EnvironmentProviderType;
import com.github.thedeathlycow.thermoo.api.environment.provider.EnvironmentProviderTypes;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.Objects;
import java.util.Optional;
import net.minecraft.class_1937;
import net.minecraft.class_1959;
import net.minecraft.class_2338;
import net.minecraft.class_6880;
import net.minecraft.class_9323;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.Nullable;

public final class WeatherStateEnvironmentProvider
implements EnvironmentProvider {
    public static final MapCodec<WeatherStateEnvironmentProvider> CODEC = RecordCodecBuilder.mapCodec(instance -> instance.group((App)EnvironmentProvider.HOLDER_CODEC.optionalFieldOf("clear").forGetter(WeatherStateEnvironmentProvider::clear), (App)EnvironmentProvider.HOLDER_CODEC.optionalFieldOf("rain").forGetter(WeatherStateEnvironmentProvider::rain), (App)EnvironmentProvider.HOLDER_CODEC.optionalFieldOf("thunder").forGetter(WeatherStateEnvironmentProvider::thunder)).apply((Applicative)instance, WeatherStateEnvironmentProvider::new));
    private final Optional<class_6880<EnvironmentProvider>> clear;
    private final Optional<class_6880<EnvironmentProvider>> rain;
    private final Optional<class_6880<EnvironmentProvider>> thunder;

    private WeatherStateEnvironmentProvider(Optional<class_6880<EnvironmentProvider>> clear, Optional<class_6880<EnvironmentProvider>> rain, Optional<class_6880<EnvironmentProvider>> thunder) {
        this.clear = clear;
        this.rain = rain;
        this.thunder = thunder;
    }

    @Contract(value="->new")
    public static Builder builder() {
        return new Builder();
    }

    @Override
    public void buildCurrentComponents(class_1937 level, class_2338 pos, class_6880<class_1959> biome, class_9323.class_9324 builder) {
        if (level.method_8546()) {
            this.thunder.ifPresent(p -> ((EnvironmentProvider)p.comp_349()).buildCurrentComponents(level, pos, biome, builder));
        } else if (level.method_8419()) {
            this.rain.ifPresent(p -> ((EnvironmentProvider)p.comp_349()).buildCurrentComponents(level, pos, biome, builder));
        } else {
            this.clear.ifPresent(p -> ((EnvironmentProvider)p.comp_349()).buildCurrentComponents(level, pos, biome, builder));
        }
    }

    public EnvironmentProviderType<WeatherStateEnvironmentProvider> getType() {
        return EnvironmentProviderTypes.WEATHER_STATE;
    }

    public Optional<class_6880<EnvironmentProvider>> clear() {
        return this.clear;
    }

    public Optional<class_6880<EnvironmentProvider>> rain() {
        return this.rain;
    }

    public Optional<class_6880<EnvironmentProvider>> thunder() {
        return this.thunder;
    }

    public static final class Builder {
        @Nullable
        private class_6880<EnvironmentProvider> clear = null;
        @Nullable
        private class_6880<EnvironmentProvider> rain = null;
        @Nullable
        private class_6880<EnvironmentProvider> thunder = null;

        private Builder() {
        }

        @Contract(value="_->this")
        public Builder withClear(class_6880<EnvironmentProvider> clear) {
            Objects.requireNonNull(clear);
            this.clear = clear;
            return this;
        }

        @Contract(value="_->this")
        public Builder withRain(class_6880<EnvironmentProvider> rain) {
            Objects.requireNonNull(rain);
            this.rain = rain;
            return this;
        }

        @Contract(value="_->this")
        public Builder withThunder(class_6880<EnvironmentProvider> thunder) {
            Objects.requireNonNull(thunder);
            this.thunder = thunder;
            return this;
        }

        @Contract(value="->new")
        public WeatherStateEnvironmentProvider build() {
            return new WeatherStateEnvironmentProvider(Optional.ofNullable(this.clear), Optional.ofNullable(this.rain), Optional.ofNullable(this.thunder));
        }
    }
}

