/*
 * Decompiled with CFR 0.152.
 */
package com.github.thedeathlycow.thermoo.api.util;

import com.github.thedeathlycow.thermoo.api.util.TemperatureUnit;
import java.util.HashSet;
import java.util.Locale;
import java.util.Set;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_1076;
import net.minecraft.class_310;

public final class TemperatureUnitLookup {
    private static final Set<String> ISO_REGIONS_THAT_USE_FAHRENHEIT = new HashSet<String>(Set.of("US", "UM", "VI", "AS", "PR", "GU", "MP", "LR", "BS", "FM", "MH", "KY", "BZ", "AG", "KN"));

    @Environment(value=EnvType.CLIENT)
    public static TemperatureUnit fromCurrentLanguage() {
        class_1076 manager = class_310.method_1551().method_1526();
        return manager.method_4669().endsWith("_us") ? TemperatureUnit.FAHRENHEIT : TemperatureUnit.CELSIUS;
    }

    public static TemperatureUnit fromLanguageCode(String mcLanguageCode) {
        return mcLanguageCode.endsWith("_us") ? TemperatureUnit.FAHRENHEIT : TemperatureUnit.CELSIUS;
    }

    public static TemperatureUnit fromLocale() {
        return TemperatureUnitLookup.fromLocale(Locale.getDefault());
    }

    public static TemperatureUnit fromLocale(Locale locale) {
        return ISO_REGIONS_THAT_USE_FAHRENHEIT.contains(locale.getCountry().toUpperCase()) ? TemperatureUnit.FAHRENHEIT : TemperatureUnit.CELSIUS;
    }

    private TemperatureUnitLookup() {
    }
}

