/*
 * Decompiled with CFR 0.152.
 */
package com.github.thedeathlycow.thermoo.impl;

import com.github.thedeathlycow.thermoo.api.ThermooRegistryKeys;
import com.github.thedeathlycow.thermoo.api.command.EnvironmentCommand;
import com.github.thedeathlycow.thermoo.api.command.HeatingModeArgumentType;
import com.github.thedeathlycow.thermoo.api.command.SoakingCommand;
import com.github.thedeathlycow.thermoo.api.command.TemperatureCommand;
import com.github.thedeathlycow.thermoo.api.command.TemperatureUnitArgumentType;
import com.github.thedeathlycow.thermoo.api.environment.EnvironmentDefinition;
import com.github.thedeathlycow.thermoo.api.environment.provider.EnvironmentProvider;
import com.github.thedeathlycow.thermoo.impl.ThermooCommonRegisters;
import com.github.thedeathlycow.thermoo.impl.compat.init.DependentModInitializer;
import com.github.thedeathlycow.thermoo.impl.config.ThermooConfig;
import com.github.thedeathlycow.thermoo.impl.environment.EnvironmentLookupImpl;
import com.github.thedeathlycow.thermoo.impl.temperature.effect.TemperatureEffectLoader;
import java.util.Arrays;
import java.util.List;
import net.fabricmc.api.ModInitializer;
import net.fabricmc.fabric.api.command.v2.ArgumentTypeRegistry;
import net.fabricmc.fabric.api.command.v2.CommandRegistrationCallback;
import net.fabricmc.fabric.api.event.registry.DynamicRegistries;
import net.fabricmc.fabric.api.resource.ResourceManagerHelper;
import net.fabricmc.loader.api.FabricLoader;
import net.minecraft.class_2314;
import net.minecraft.class_2319;
import net.minecraft.class_2960;
import net.minecraft.class_3264;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Thermoo
implements ModInitializer {
    public static final String MODID = "thermoo";
    public static final Logger LOGGER = LoggerFactory.getLogger((String)"thermoo");
    public static final class_2314<HeatingModeArgumentType, class_2319.class_7219> HEATING_MODE_ARG_SERIALIZER = class_2319.method_41999(HeatingModeArgumentType::heatingMode);
    public static final class_2314<TemperatureUnitArgumentType, class_2319.class_7219> TEMPERATURE_UNIT_ARG_SERIALIZER = class_2319.method_41999(TemperatureUnitArgumentType::temperatureUnit);
    @Nullable
    private static ThermooConfig config = null;

    public void onInitialize() {
        ArgumentTypeRegistry.registerArgumentType((class_2960)Thermoo.location("heating_mode"), HeatingModeArgumentType.class, HEATING_MODE_ARG_SERIALIZER);
        ArgumentTypeRegistry.registerArgumentType((class_2960)Thermoo.location("temperature_unit"), TemperatureUnitArgumentType.class, TEMPERATURE_UNIT_ARG_SERIALIZER);
        CommandRegistrationCallback.EVENT.register((dispatcher, registryAccess, environment) -> {
            dispatcher.register(TemperatureCommand.COMMAND_BUILDER.get());
            dispatcher.register(EnvironmentCommand.COMMAND_BUILDER.get());
            dispatcher.register(SoakingCommand.COMMAND_BUILDER.get());
        });
        DynamicRegistries.register(ThermooRegistryKeys.ENVIRONMENT, EnvironmentDefinition.CODEC);
        DynamicRegistries.register(ThermooRegistryKeys.ENVIRONMENT_PROVIDER, EnvironmentProvider.ELEMENT_CODEC);
        ThermooCommonRegisters.registerTemperatureEffects();
        ThermooCommonRegisters.registerEnvironmentProviderTypes();
        ThermooCommonRegisters.registerLootConditionTypes();
        ResourceManagerHelper serverManager = ResourceManagerHelper.get((class_3264)class_3264.field_14190);
        serverManager.registerReloadListener(TemperatureEffectLoader.ID, TemperatureEffectLoader::new);
        EnvironmentLookupImpl.initialize();
        Thermoo.initializeDependentEntryPoints();
        LOGGER.info("Thermoo initialized");
    }

    @Contract(value="_->new")
    public static class_2960 location(String path) {
        return class_2960.method_60655((String)MODID, (String)path);
    }

    public static ThermooConfig getConfig() {
        if (config == null) {
            config = ThermooConfig.create();
        }
        return config;
    }

    private static void initializeDependentEntryPoints() {
        List initializers = FabricLoader.getInstance().getEntrypoints("thermoo-dependent-mod", DependentModInitializer.class);
        for (DependentModInitializer initializer : initializers) {
            boolean initialize = Arrays.stream(initializer.getRequiredModIds()).allMatch(id -> FabricLoader.getInstance().isModLoaded(id));
            if (!initialize) continue;
            initializer.onInitialize();
        }
    }
}

