/*
 * Decompiled with CFR 0.152.
 */
package com.github.thedeathlycow.thermoo.impl.compat;

import com.github.thedeathlycow.thermoo.impl.compat.PatchedVersion;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.ArrayList;
import java.util.List;
import net.fabricmc.loader.api.FabricLoader;
import net.fabricmc.loader.api.ModContainer;
import net.fabricmc.loader.api.Version;
import net.fabricmc.loader.api.VersionParsingException;
import net.fabricmc.loader.api.metadata.version.VersionPredicate;

public record PatchList(List<PatchedVersion> patches) {
    public static final Codec<PatchList> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)PatchedVersion.CODEC.listOf().fieldOf("patches").forGetter(PatchList::patches)).apply((Applicative)instance, PatchList::new));

    public List<ModContainer> getPatchAvailableMods(FabricLoader loader) throws VersionParsingException {
        Version gameVersion = ((ModContainer)loader.getModContainer("minecraft").orElseThrow()).getMetadata().getVersion();
        ArrayList<ModContainer> patchAvailableMods = new ArrayList<ModContainer>();
        for (PatchedVersion patch : this.patches) {
            VersionPredicate predicate = VersionPredicate.parse((String)patch.minecraftVersion());
            if (!predicate.test((Object)gameVersion)) continue;
            this.extendPatchAvailableMods(loader, patchAvailableMods, patch);
        }
        return patchAvailableMods;
    }

    private void extendPatchAvailableMods(FabricLoader loader, List<ModContainer> patchAvailableMods, PatchedVersion patch) {
        for (String modid : patch.mods()) {
            loader.getModContainer(modid).ifPresent(patchAvailableMods::add);
        }
    }
}

