package com.github.thedeathlycow.thermoo.api.armor.material;

import net.fabricmc.fabric.api.event.Event;
import net.fabricmc.fabric.api.event.EventFactory;
import net.minecraft.class_1738;
import net.minecraft.class_1741;
import net.minecraft.class_6880;

/**
 * Events for getting the thermal resistances of various {@linkplain class_1741 armor materials}
 *
 * @deprecated Removed in 1.21.2+, replaced with {@link com.github.thedeathlycow.thermoo.api.item.ModifyItemAttributeModifiersCallback}
 */
@Deprecated
public class ArmorMaterialEvents {

    /**
     * Gets the {@linkplain com.github.thedeathlycow.thermoo.api.ThermooAttributes#HEAT_RESISTANCE heat resistance}
     * for a particular {@linkplain class_1741 armor material} and {@linkplain class_1738.class_8051 armor type}.
     * <p>
     * If returns 0 or {@link Double#NaN} then no heat resistance is applied.
     * <p>
     * It is recommended to base the resistance amount on the material {@linkplain ArmorMaterialTags tag}.
     * <p>
     * Known issue: using tags is not world-specific, so please do not use these tags in datapacks that aren't meant to
     * be applied globally.
     */
    public static final Event<GetResistance> GET_HEAT_RESISTANCE = EventFactory.createArrayBacked(
            GetResistance.class,
            listeners -> (armorMaterial, armorType) -> {
                for (GetResistance listener : listeners) {
                    double value = listener.getValue(armorMaterial, armorType);
                    if (value != 0 && !Double.isNaN(value)) {
                        return value;
                    }
                }

                return Double.NaN;
            }
    );

    /**
     * Gets the {@linkplain com.github.thedeathlycow.thermoo.api.ThermooAttributes#FROST_RESISTANCE frost resistance}
     * for a particular {@linkplain class_1741 armor material} and {@linkplain class_1738.class_8051 armor type}.
     * <p>
     * If returns 0 or {@link Double#NaN} then no frost resistance is applied.
     * <p>
     * It is recommended to base the resistance amount on the material {@linkplain ArmorMaterialTags tag}.
     * <p>
     * Known issue: using tags is not world-specific, so please do not use these tags in datapacks that aren't meant to
     * be applied globally.
     */
    public static final Event<GetResistance> GET_FROST_RESISTANCE = EventFactory.createArrayBacked(
            GetResistance.class,
            listeners -> (armorMaterial, armorType) -> {
                for (GetResistance listener : listeners) {
                    double value = listener.getValue(armorMaterial, armorType);
                    if (value != 0 && !Double.isNaN(value)) {
                        return value;
                    }
                }

                return Double.NaN;
            }
    );

    @FunctionalInterface
    @Deprecated
    public interface GetResistance {

        double getValue(class_6880<class_1741> armorMaterial, class_1738.class_8051 armorType);

    }

}
