package com.github.thedeathlycow.thermoo.api.environment.component;

import com.github.thedeathlycow.thermoo.api.ThermooRegistries;
import com.github.thedeathlycow.thermoo.api.util.TemperatureRecord;
import com.github.thedeathlycow.thermoo.impl.Thermoo;
import com.mojang.serialization.Codec;
import java.util.function.UnaryOperator;
import net.minecraft.class_2378;
import net.minecraft.class_9323;
import net.minecraft.class_9331;

/**
 * Stores the codec and component type keys for Thermoo's environment component map.
 * <p>
 * Mods may define their own component types in their own classes, they only need be registered to
 * {@link ThermooRegistries#ENVIRONMENT_COMPONENT_TYPE}.
 */
public final class EnvironmentComponentTypes {
    public static final Codec<class_9331<?>> COMPONENT_TYPE_CODEC = Codec.lazyInitialized(
            ThermooRegistries.ENVIRONMENT_COMPONENT_TYPE::method_39673
    );
    public static final Codec<class_9323> COMPONENT_MAP_CODEC = class_9323.method_60386(COMPONENT_TYPE_CODEC);

    /**
     * Stores a temperature reading in {@link com.github.thedeathlycow.thermoo.api.util.TemperatureUnit a unit} such as
     * Celsius, Fahrenheit, Kelvin, or Rankine.
     *
     * @see TemperatureRecordComponent
     */
    public static final class_9331<TemperatureRecord> TEMPERATURE = register(
            "temperature",
            builder -> builder.method_57881(TemperatureRecordComponent.CODEC)
    );

    /**
     * Stores relative humidity on a 0-1 percentage scale.
     * <p>
     * Relative humidity is defined as "the ratio of how much water vapour is in the air to how much water vapour the
     * air could potentially contain" <a href="https://en.m.wikipedia.org/wiki/Humidity#Relative_humidity">[1]</a> and
     * is expressed here on a 0-1 scale.
     *
     * @see RelativeHumidityComponent
     */
    public static final class_9331<Double> RELATIVE_HUMIDITY = register(
            "relative_humidity",
            builder -> builder.method_57881(RelativeHumidityComponent.CODEC)
    );

    private static <T> class_9331<T> register(
            String name,
            UnaryOperator<class_9331.class_9332<T>> builderOperator
    ) {
        return class_2378.method_10230(
                ThermooRegistries.ENVIRONMENT_COMPONENT_TYPE,
                Thermoo.id(name),
                builderOperator.apply(class_9331.method_57873())
                        .method_57880()
        );
    }

    private EnvironmentComponentTypes() {
    }
}