package com.github.thedeathlycow.thermoo.api.predicate;

import com.github.thedeathlycow.thermoo.api.temperature.TemperatureAware;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import net.minecraft.class_1297;
import net.minecraft.class_181;
import net.minecraft.class_2096;
import net.minecraft.class_47;
import net.minecraft.class_5341;
import net.minecraft.class_5342;

/**
 * Loot condition used to test the soaking values of an entity in a predicate. Only works for entities that implement
 * {@link TemperatureAware}, which by default is only {@link net.minecraft.class_1309}. All other entities will
 * always return false.
 *
 * @param value The {@linkplain TemperatureAware#thermoo$getTemperature() temperature value}
 * @param scale The {@linkplain TemperatureAware#thermoo$getTemperatureScale() temperature scale}
 */
public record TemperatureLootCondition(
        class_2096.class_2100 value,
        class_2096.class_2099 scale
) implements class_5341 {

    public static final MapCodec<TemperatureLootCondition> CODEC = RecordCodecBuilder.mapCodec(
            instance -> instance.group(
                    class_2096.class_2100.field_45763
                            .fieldOf("value")
                            .orElse(class_2096.class_2100.field_9708)
                            .forGetter(TemperatureLootCondition::value),
                    class_2096.class_2099.field_45762
                            .fieldOf("scale")
                            .orElse(class_2096.class_2099.field_9705)
                            .forGetter(TemperatureLootCondition::scale)
            ).apply(instance, TemperatureLootCondition::new)
    );

    @Override
    public class_5342 method_29325() {
        return ThermooLootConditionTypes.TEMPERATURE;
    }

    @Override
    public boolean test(class_47 lootContext) {
        class_1297 entity = lootContext.method_296(class_181.field_1226);
        if (entity instanceof TemperatureAware temperatureAware) {
            return this.value.method_9054(temperatureAware.thermoo$getTemperature())
                    && this.scale.method_9047(temperatureAware.thermoo$getTemperatureScale());
        }

        return false;
    }

    public static class_5341.class_210 builder(class_2096.class_2100 value) {
        return () -> new TemperatureLootCondition(value, class_2096.class_2099.field_9705);
    }

    public static class_5341.class_210 builder(class_2096.class_2099 scale) {
        return () -> new TemperatureLootCondition(class_2096.class_2100.field_9708, scale);
    }
}
