package com.github.thedeathlycow.thermoo.api.temperature;

import net.minecraft.class_1309;
import net.minecraft.class_1320;
import net.minecraft.class_1657;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2680;
import net.minecraft.class_6880;
import org.jetbrains.annotations.Nullable;
import oshi.annotation.concurrent.Immutable;

/**
 * Implements computations for various passive environmental effects, such as passive freezing/warming from biomes,
 * and passive warming from heat sources (torches, campfires, etc).
 * <p>
 * The default implementation is provided by {@link EmptyEnvironmentController} which sets all values to either 0, false,
 * or null by default, except where noted. However, if you wish you may extend (or even replace!) the functionality of
 * the default controller by use of the {@link EnvironmentControllerDecorator}. It is best to do this through the
 * initialize event in {@link com.github.thedeathlycow.thermoo.api.temperature.event.EnvironmentControllerInitializeEvent}
 *
 * @see EnvironmentControllerDecorator
 * @see EmptyEnvironmentController
 * @deprecated Replaced with {@linkplain com.github.thedeathlycow.thermoo.api.environment.EnvironmentDefinition the environment datapack registry}
 */
@Immutable
@Deprecated(forRemoval = true, since = "4.4")
public sealed interface EnvironmentController permits EnvironmentControllerDecorator, EmptyEnvironmentController {

    /**
     * Gets the controller that this controller decorates. If this controller is a leaf (not a decorator), then returns
     * null.
     *
     * @return Returns the environment controller that this controller decorates. Returns null if this decorates no
     * controller (i.e., is a leaf)
     */
    @Nullable
    default EnvironmentController getDecorated() {
        return null;
    }

    /**
     * Gets the base value for one of the {@link com.github.thedeathlycow.thermoo.api.ThermooAttributes}. If the return of
     * this method is non-zero, then this value will be applied as an attribute modifier to the {@code entity} when the
     * entity is created, with the addition operation. This method is called for each of the Thermoo attributes.
     *
     * @param attribute The attribute to get the base value for. Strictly the attributes in {@link com.github.thedeathlycow.thermoo.api.ThermooAttributes}.
     * @param entity    The entity to apply the attribute to.
     * @return Returns the base value for the attribute to apply to the entity.
     * @deprecated Use {@link com.github.thedeathlycow.thermoo.api.ThermooAttributes#baseValueEvent(class_6880)}
     */
    @Deprecated(since = "4.3", forRemoval = true)
    double getBaseValueForAttribute(class_6880<class_1320> attribute, class_1309 entity);

    /**
     * Computes the local temperature change from the environment at a given position in a world.
     *
     * @param world The world
     * @param pos   The position in that world
     * @return The passive temperature change at {@code pos} in {@code world}.
     * @deprecated Replaced with {@link com.github.thedeathlycow.thermoo.api.environment.event.ServerPlayerEnvironmentTickEvents}
     */
    @Deprecated(since = "4.4")
    int getLocalTemperatureChange(class_1937 world, class_2338 pos);

    /**
     * Computes the environmental temperature change for a player, based on a local temperature computed from
     * {@link #getLocalTemperatureChange(class_1937, class_2338)}.
     * <p>
     * By default, this returns the value of {@code localTemperature}, and NOT {@code 0}.
     *
     * @param player           The player to compute the temperature change for
     * @param localTemperature The base local temperature
     * @return Returns the passive environmental temperature change for the player this tick
     * @deprecated Replaced with {@link com.github.thedeathlycow.thermoo.api.environment.event.ServerPlayerEnvironmentTickEvents}
     */
    @Deprecated(since = "4.4")
    default int getEnvironmentTemperatureForPlayer(class_1657 player, int localTemperature) {
        return localTemperature;
    }

    /**
     * Computes temperature changes for {@link class_1309}s from heat effects. For example, being on fire or freezing
     * in powder snow
     *
     * @param entity The entity to tick warmth effects for
     * @return Returns the temperature change that should be applied
     * @deprecated Use the active effects in {@link com.github.thedeathlycow.thermoo.api.temperature.event.LivingEntityTemperatureTickEvents}
     */
    @Deprecated(since = "4.4")
    int getTemperatureEffectsChange(class_1309 entity);

    /**
     * Gets the amount of warmth generated by a floor block state for a given entity.
     * <p>
     * Hot floor is different from {@link #getHeatFromBlockState(class_2680)}, as it ONLY applies to entities stepping on
     * the block - it does not affect the area around the block. An example implementation would be to provide warmth from
     * {@link net.minecraft.class_2246#field_10092}, but not provide area heat.
     * <p>
     * You can also use this for blocks that are cold to step on.
     *
     * @param entity The entity that is stepping on the given {@code state}
     * @param world  The world/level where the floor is located
     * @param state  The state of the floor. This is exactly the state at the {@code pos} in the {@code world}
     * @param pos    The position of the world in the world
     * @return Returns the heat to apply each tick to entities standing on the block state
     * @deprecated Use the passive effects in {@link com.github.thedeathlycow.thermoo.api.temperature.event.LivingEntityTemperatureTickEvents}
     */
    @Deprecated(since = "4.4")
    int getFloorTemperature(class_1309 entity, class_1937 world, class_2680 state, class_2338 pos);

    /**
     * Gets the default maximum wet ticks for the {@code soakable}.
     * <p>
     * Important note - so that behaviour will remain consistent with previous versions,
     * this will return {@code 600} by default, instead of the normal {@code 0} for this type.
     *
     * @param soakable The soakable to get the max wet ticks for.
     * @return Returns the default maximum wet ticks for the {@code soakable}
     * @deprecated Replaced with an attribute: {@link com.github.thedeathlycow.thermoo.api.ThermooAttributes#MAX_SOAKING_TICK_MULTIPLIER}
     */
    @Deprecated(since = "4.4")
    default int getMaxWetTicks(Soakable soakable) {
        return 600;
    }

    /**
     * Gets the wetness increase for a {@link Soakable} this tick
     *
     * @param soakable The soakable to compute increase for
     * @return Returns the soaking change for the player.
     * @deprecated Replaced with {@link com.github.thedeathlycow.thermoo.api.temperature.event.LivingEntitySoakingTickEvents}
     */
    @Deprecated(since = "4.4")
    int getSoakChange(Soakable soakable);

    /**
     * Calculates the passive warmth nearby heat sources at a location in a world.
     * 'Heat sources' being things that exist in the world that produce heat around them. For example, this could include
     * artificial light producing sources, such as torches, campfires, lit furnaces, glowstone, and more.
     * <p>
     * This can also be negative, to indicate a cold position.
     *
     * @param world The world the temperature aware is in
     * @param pos   The position to check
     * @return Returns the temperature change that should be applied from nearby temperature sources.
     * @deprecated Use the passive effects in  {@link com.github.thedeathlycow.thermoo.api.temperature.event.LivingEntityTemperatureTickEvents}
     */
    @Deprecated(since = "4.4")
    int getHeatAtLocation(class_1937 world, class_2338 pos);

    /**
     * Gets the heat {@linkplain #getHeatAtLocation(class_1937, class_2338) from nearby heat sources} to apply to a Temperature
     * Aware this tick.
     * <p>
     * By default, the temperature aware will accept all heat from nearby heat sources.
     *
     * @param temperatureAware The temperature aware affected.
     * @param locationHeat     The heat at the temperature aware's location, as computed by
     *                         {@link #getHeatAtLocation(class_1937, class_2338)}
     * @return Returns {@code locationHeat} by default.
     * @deprecated Use the passive effects in {@link com.github.thedeathlycow.thermoo.api.temperature.event.LivingEntityTemperatureTickEvents}
     */
    @Deprecated(since = "4.4")
    default int applyAwareHeat(TemperatureAware temperatureAware, int locationHeat) {
        return locationHeat;
    }

    /**
     * Calculates the heat produced by a block state. May be negative, indicating a cold source.
     *
     * @param state The block state heat source
     * @return The warmth that the state produces around it
     * @deprecated Use the passive effects in {@link com.github.thedeathlycow.thermoo.api.temperature.event.LivingEntityTemperatureTickEvents}
     */
    @Deprecated(since = "4.4")
    int getHeatFromBlockState(class_2680 state);

    /**
     * Checks if a block state is a heat source, as defined by this controller.
     *
     * @param state The block state to check
     * @return Returns if a block state is a heat source
     * @see EnvironmentController#getHeatFromBlockState(class_2680)
     * @deprecated Use the passive effects in {@link com.github.thedeathlycow.thermoo.api.temperature.event.LivingEntityTemperatureTickEvents}
     */
    @Deprecated(since = "4.4")
    boolean isHeatSource(class_2680 state);

    /**
     * Checks if a block state is a cold source, as defined by this controller.
     *
     * @param state The block state to check
     * @return Returns true if a block state is a cold source
     * @see EnvironmentController#getHeatFromBlockState(class_2680)
     * @deprecated Use the passive effects in {@link com.github.thedeathlycow.thermoo.api.temperature.event.LivingEntityTemperatureTickEvents}
     */
    @Deprecated(since = "4.4")
    boolean isColdSource(class_2680 state);

    /**
     * Check if a position in a world is heated
     *
     * @param world The world of the position
     * @param pos   The position to check
     * @return Returns if the location in the world is heated
     * @see EnvironmentController#getHeatAtLocation(class_1937, class_2338)
     * @deprecated Use the passive effects in {@link com.github.thedeathlycow.thermoo.api.temperature.event.LivingEntityTemperatureTickEvents}
     */
    @Deprecated(since = "4.4")
    boolean isAreaHeated(class_1937 world, class_2338 pos);
}
