package com.github.thedeathlycow.thermoo.api.temperature.effects;

import com.github.thedeathlycow.thermoo.impl.Thermoo;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import net.fabricmc.fabric.api.event.lifecycle.v1.ServerLifecycleEvents;
import net.minecraft.class_1282;
import net.minecraft.class_1309;
import net.minecraft.class_2378;
import net.minecraft.class_3218;
import net.minecraft.class_5321;
import net.minecraft.class_5455;
import net.minecraft.class_5699;
import net.minecraft.class_7924;
import net.minecraft.class_8110;
import org.jetbrains.annotations.Nullable;

import java.util.HashMap;
import java.util.Map;

/**
 * Applies damage to {@link net.minecraft.class_1309}s when their temperature scale is within a given range.
 * The amount and interval of the damage pulses can be configured, as well as the damage type. However, the {@link class_1282}
 * applied only stores the type - the direct source entity, attacker, and position are all {@code null}.
 */
public class DamageTemperatureEffect extends TemperatureEffect<DamageTemperatureEffect.Config> {

    public static final Codec<Config> CODEC = RecordCodecBuilder.create(
            instance -> instance.group(
                    class_5699.field_34387
                            .fieldOf("amount")
                            .forGetter(Config::amount),
                    class_5699.field_33442
                            .fieldOf("damage_interval")
                            .forGetter(Config::damageInterval),
                    class_5321.method_39154(class_7924.field_42534)
                            .fieldOf("damage_type")
                            .forGetter(config -> config.damageType)
            ).apply(instance, Config::new)
    );

    @Nullable
    private class_2378<class_8110> registry;

    private final Map<class_5321<class_8110>, class_1282> damageSourcePool = new HashMap<>();

    public DamageTemperatureEffect(Codec<Config> codec) {
        super(codec);
        ServerLifecycleEvents.SERVER_STARTING.register(
                server -> this.invalidateRegistryCache()
        );
        ServerLifecycleEvents.SERVER_STOPPING.register(
                server -> this.invalidateRegistryCache()
        );
        ServerLifecycleEvents.START_DATA_PACK_RELOAD.register(
                (server, resourceManager) -> this.invalidateRegistryCache()
        );
    }

    @Override
    public void apply(class_1309 victim, class_3218 serverWorld, Config config) {

        if (registry == null) {
            class_5455 registryManager = serverWorld.method_8503().method_30611();
            this.registry = registryManager.method_30530(class_7924.field_42534);
        }

        class_1282 source = this.getDamageSourceFromType(config.damageType, this.registry);
        if (source != null) {
            victim.method_5643(source, config.amount);
        }
    }

    @Override
    public boolean shouldApply(class_1309 victim, Config config) {
        return victim.field_6012 % config.damageInterval == 0 && config.amount != 0.0f;
    }

    @Nullable
    private class_1282 getDamageSourceFromType(class_5321<class_8110> damageType, class_2378<class_8110> registry) {
        return this.damageSourcePool.computeIfAbsent(
                damageType,
                key -> {
                    if (!registry.method_35842(key)) {
                        Thermoo.LOGGER.error("Temperature effect trying to use unknown damage type {}", key);
                        return null;
                    }
                    return new class_1282(registry.method_40290(key));
                }
        );
    }

    private void invalidateRegistryCache() {
        this.registry = null;
        this.damageSourcePool.clear();
        Thermoo.LOGGER.info("Invalidated damage temperature effect registry cache");
    }

    public record Config(
            float amount,
            int damageInterval,
            class_5321<class_8110> damageType
    ) {

    }

}
