package com.github.thedeathlycow.thermoo.impl;

import com.github.thedeathlycow.thermoo.api.environment.EnvironmentLookup;
import com.github.thedeathlycow.thermoo.api.temperature.HeatingMode;
import com.github.thedeathlycow.thermoo.api.temperature.HeatingModes;
import com.github.thedeathlycow.thermoo.api.temperature.event.EnvironmentTickContext;
import com.github.thedeathlycow.thermoo.api.temperature.event.LivingEntitySoakingTickEvents;
import com.github.thedeathlycow.thermoo.api.temperature.event.LivingEntityTemperatureTickEvents;
import com.github.thedeathlycow.thermoo.impl.environment.EnvironmentTickContextImpl;
import com.github.thedeathlycow.thermoo.impl.environment.ServerPlayerTickUtil;
import net.fabricmc.fabric.api.event.Event;
import net.fabricmc.fabric.api.util.TriState;
import net.minecraft.class_1309;
import net.minecraft.class_2338;
import net.minecraft.class_2349;
import net.minecraft.class_243;
import net.minecraft.class_2680;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.class_3481;
import net.minecraft.class_3532;
import net.minecraft.class_9323;

public final class LivingEntityTickUtil {
    public static void tick(class_1309 entity) {
        if (entity.method_29504() || entity.method_31481()) {
            return;
        }

        if (entity.method_37908() instanceof class_3218 serverWorld) {
            class_2338 pos = getTemperatureTickPos(entity);
            if (entity instanceof class_3222 player) {
                EnvironmentTickContext<class_3222> context = new EnvironmentTickContextImpl<>(
                        player,
                        serverWorld,
                        pos,
                        EnvironmentLookup.getInstance().findEnvironmentComponents(serverWorld, pos)
                );
                invokeEntityEvents(context);
                ServerPlayerTickUtil.invokePlayerTemperatureEvents(context);
            } else {
                EnvironmentTickContext<class_1309> context = new EnvironmentTickContextImpl<>(
                        entity,
                        serverWorld,
                        pos,
                        class_9323.field_49584
                );
                invokeEntityEvents(context);
            }
        }
    }

    /**
     * used to offset effects like being stuck in mud
     *
     * @return returns a blockpos shifted up 0.21 blocks from the entity's current position
     */
    public static class_2338 getTemperatureTickPos(class_1309 entity) {
        class_243 pos = entity.method_19538();
        final float offset = 0.21f;
        if (entity.field_44784.isPresent()) {
            class_2338 blockPos = entity.field_44784.get();
            class_2680 blockState = entity.method_37908().method_8320(blockPos);
            return !blockState.method_26164(class_3481.field_16584) && !blockState.method_26164(class_3481.field_15504) && !(blockState.method_26204() instanceof class_2349)
                    ? blockPos.method_33096(class_3532.method_15357(pos.field_1351 + offset))
                    : blockPos;
        } else {
            return new class_2338(
                    class_3532.method_15357(pos.field_1352),
                    class_3532.method_15357(pos.field_1351 + offset),
                    class_3532.method_15357(pos.field_1350)
            );
        }
    }

    private static void invokeEntityEvents(EnvironmentTickContext<? extends class_1309> context) {
        tickSoakingChange(
                context,
                LivingEntitySoakingTickEvents.ALLOW_SOAKING_UPDATE,
                LivingEntitySoakingTickEvents.GET_SOAKING_CHANGE,
                LivingEntitySoakingTickEvents.ALLOW_SOAKING_CHANGE
        );
        tickTemperatureChange(
                context,
                HeatingModes.PASSIVE,
                LivingEntityTemperatureTickEvents.ALLOW_PASSIVE_TEMPERATURE_UPDATE,
                LivingEntityTemperatureTickEvents.GET_PASSIVE_TEMPERATURE_CHANGE,
                LivingEntityTemperatureTickEvents.ALLOW_PASSIVE_TEMPERATURE_CHANGE
        );

        tickTemperatureChange(
                context,
                HeatingModes.ACTIVE,
                LivingEntityTemperatureTickEvents.ALLOW_ACTIVE_TEMPERATURE_UPDATE,
                LivingEntityTemperatureTickEvents.GET_ACTIVE_TEMPERATURE_CHANGE,
                LivingEntityTemperatureTickEvents.ALLOW_ACTIVE_TEMPERATURE_CHANGE
        );
    }

    private static void tickTemperatureChange(
            EnvironmentTickContext<? extends class_1309> context,
            HeatingMode heatingMode,
            Event<LivingEntityTemperatureTickEvents.AllowTemperatureUpdate> allowUpdate,
            Event<LivingEntityTemperatureTickEvents.GetTemperatureChange> getTempChange,
            Event<LivingEntityTemperatureTickEvents.AllowTemperatureChange> allowChange
    ) {
        if (allowUpdate.invoker().allowUpdate(context) == TriState.FALSE) {
            return;
        }

        int tempChange = getTempChange.invoker().addTemperature(context);
        if (tempChange != 0 && allowChange.invoker().allowChange(context, tempChange) != TriState.FALSE) {
            context.affected().thermoo$addTemperature(tempChange, heatingMode);
        }
    }

    private static void tickSoakingChange(
            EnvironmentTickContext<? extends class_1309> context,
            Event<LivingEntitySoakingTickEvents.AllowSoakingUpdate> allowUpdate,
            Event<LivingEntitySoakingTickEvents.GetSoakingChange> addSoakChange,
            Event<LivingEntitySoakingTickEvents.AllowSoakingChange> allowChange
    ) {
        if (allowUpdate.invoker().allowUpdate(context) == TriState.FALSE) {
            return;
        }

        int soakingChange = addSoakChange.invoker().addChange(context);

        if (soakingChange != 0 && allowChange.invoker().allowChange(context, soakingChange) != TriState.FALSE) {
            context.affected().thermoo$addWetTicks(soakingChange);
        }
    }

    private LivingEntityTickUtil() {
    }
}