package com.github.thedeathlycow.thermoo.api;

import com.github.thedeathlycow.thermoo.impl.Thermoo;
import com.github.thedeathlycow.thermoo.impl.attribute.AttributeData;
import net.fabricmc.fabric.api.event.Event;
import net.minecraft.class_1309;
import net.minecraft.class_1320;
import net.minecraft.class_1329;
import net.minecraft.class_2378;
import net.minecraft.class_6880;
import net.minecraft.class_7923;
import org.jetbrains.annotations.ApiStatus;

/**
 * Custom {@link class_1320}s provided by Thermoo
 */
public final class ThermooAttributes {

    /**
     * The minimum temperature of an entity. By default, this is 0.
     * <p>
     * Note that this is separate from {@link #MAX_TEMPERATURE}. Each point of this attribute is decreases the minimum
     * temperature of an entity by 140 points (140 points is the maximum number of freezing ticks that entities may have
     * for powder snow freezing in vanilla).
     *
     * @see #MAX_TEMPERATURE
     */
    public static final class_6880<class_1320> MIN_TEMPERATURE = register(
            "min_temperature",
            new class_1329(
                    "attribute.thermoo.min_temperature", 0.0, 0.0, 8192
            ).method_26829(true)
    );

    /**
     * The maximum temperature of an entity. By default, this is 0.
     * <p>
     * Note that this is separate from {@link #MIN_TEMPERATURE}. Each point of this attribute is increases the maximum
     * temperature of an entity by 140 points (140 points is the maximum number of freezing ticks that entities may have
     * for powder snow freezing in vanilla).
     *
     * @see #MIN_TEMPERATURE
     */
    public static final class_6880<class_1320> MAX_TEMPERATURE = register(
            "max_temperature",
            new class_1329(
                    "attribute.thermoo.max_temperature", 0.0, 0.0, 8192
            ).method_26829(true)
    );

    /**
     * A multiplier of the base max soaking ticks value of 600. By default, this is 1.
     * <p>
     * The final max soaking tick value for living entities is floor(600 * multiplier).
     */
    public static final class_6880<class_1320> MAX_SOAKING_TICK_MULTIPLIER = register(
            "max_soaking_tick_multiplier",
            new class_1329(
                    "attribute.thermoo.max_soaking_tick_multiplier", 1.0, 0.0, 8192
            ).method_26829(true)
    );

    /**
     * The cold resistance of an entity. 1 point of frost resistance corresponds to a 10% cold reduction
     *
     * @see #HEAT_RESISTANCE
     */
    public static final class_6880<class_1320> FROST_RESISTANCE = register(
            "frost_resistance",
            new class_1329(
                    "attribute.thermoo.frost_resistance", 0.0, -10.0, 10.0
            ).method_26829(true)
    );

    /**
     * The heat resistance of an entity. 1 point of heat resistance corresponds to a 10% heat reduction
     *
     * @see #FROST_RESISTANCE
     */
    public static final class_6880<class_1320> HEAT_RESISTANCE = register(
            "heat_resistance",
            new class_1329(
                    "attribute.thermoo.heat_resistance", 0.0, -10.0, 10.0
            ).method_26829(true)
    );

    /**
     * The environment heat resistance of an entity. Environment heat resistance does not reduce the amount of heat
     * during a temperature change, but instead provides a chance to "dodge" the change all together. It is used ONLY
     * for {@link com.github.thedeathlycow.thermoo.api.environment.event.ServerPlayerEnvironmentTickEvents environment temperature changes}.
     *
     * @see #ENVIRONMENT_FROST_RESISTANCE
     */
    public static final class_6880<class_1320> ENVIRONMENT_HEAT_RESISTANCE = register(
            "environment_heat_resistance",
            new class_1329(
                    "attribute.thermoo.environment_heat_resistance", 0.0, -1.0, 1.0
            ).method_26829(true)
    );

    /**
     * The environment frost resistance of an entity. Environment frost resistance does not reduce the amount of cold
     * during a temperature change, but instead provides a chance to "dodge" the change all together. It is used ONLY
     * for {@link com.github.thedeathlycow.thermoo.api.environment.event.ServerPlayerEnvironmentTickEvents environment temperature changes}.
     *
     * @see #ENVIRONMENT_HEAT_RESISTANCE
     */
    public static final class_6880<class_1320> ENVIRONMENT_FROST_RESISTANCE = register(
            "environment_frost_resistance",
            new class_1329(
                    "attribute.thermoo.environment_frost_resistance", 0.0, -1.0, 1.0
            ).method_26829(true)
    );

    /**
     * Gets the base value event that corresponds to the attribute given. If the given attribute is not a Thermoo
     * attribute defined in this class, an {@link IllegalArgumentException} will be thrown.
     *
     * @param attribute The attribute to get the event for
     * @return Returns the event for the attribute
     * @throws IllegalArgumentException if the given attribute is not a thermoo attribute defined by this class
     */
    public static Event<SetBaseAttributeValue> baseValueEvent(class_6880<class_1320> attribute) {
        for (AttributeData data : AttributeData.values()) {
            if (attribute == data.attribute()) {
                return data.baseValueEvent();
            }
        }

        throw new IllegalArgumentException("Attribute " + attribute + " is not a Thermoo attribute!");
    }

    @FunctionalInterface
    public interface SetBaseAttributeValue {
        /**
         * Gets a base value for the event. If the value returned by this event is non-zero, then it will be applied
         * to the entity as a temporary attribute modifier using the {@link net.minecraft.class_1322.class_1323#field_6328}
         * operation.
         * <p>
         * Note: the actual base value will be unaffected. To modify the base value, use {@link net.fabricmc.fabric.api.object.builder.v1.entity.FabricDefaultAttributeRegistry}.
         * This method is simply meant to be more compatible.
         *
         * @param entity    The entity to apply the attribute value to.
         * @param baseValue The value given by other listeners. Starts from 0.
         * @return Returns the value this listener wants to apply to the modifier.
         */
        double getBaseValue(class_1309 entity, double baseValue);

        /**
         * Shorthand used for invoking this event without needing to specify the base value parameter. Should not be
         * extended by listeners.
         *
         * @param entity The entity to apply the attribute value to.
         * @return Returns the value this listener wants to apply to the modifier.
         * @see #getBaseValue(class_1309, double)
         */
        @ApiStatus.NonExtendable
        default double getBaseValue(class_1309 entity) {
            return getBaseValue(entity, 0);
        }
    }

    private static class_6880<class_1320> register(String name, class_1320 attribute) {
        return class_2378.method_47985(class_7923.field_41190, Thermoo.id(name), attribute);
    }

    private ThermooAttributes() {

    }
}
