package com.github.thedeathlycow.thermoo.api;

import com.github.thedeathlycow.thermoo.impl.Thermoo;
import net.minecraft.class_1299;
import net.minecraft.class_1792;
import net.minecraft.class_2248;
import net.minecraft.class_6862;
import net.minecraft.class_7924;

/**
 * All tags used by Thermoo. Thermoo by default leaves these tags as empty - even for vanilla entries
 */
public final class ThermooTags {

    /**
     * Entity types that benefit from being cold
     */
    public static final class_6862<class_1299<?>> BENEFITS_FROM_COLD_ENTITY_TYPE = createEntityTypeTag("benefits_from_cold");

    /**
     * Entity types that benefit from being warm
     */
    public static final class_6862<class_1299<?>> BENEFITS_FROM_HEAT_ENTITY_TYPE = createEntityTypeTag("benefits_from_heat");

    /**
     * Entity types that are cold immune
     */
    public static final class_6862<class_1299<?>> COLD_IMMUNE_ENTITY_TYPE = createEntityTypeTag("cold_immune");

    /**
     * Entity types that are heat immune
     */
    public static final class_6862<class_1299<?>> HEAT_IMMUNE_ENTITY_TYPE = createEntityTypeTag("heat_immune");

    /**
     * Conventional tag for consumables that are warming (has no effects with Thermoo alone)
     */
    public static final class_6862<class_1792> CONSUMABLE_WARMING = createItemTag("consumable/warming");

    /**
     * Conventional tag for consumables that are cooling (has no effects with Thermoo alone)
     */
    public static final class_6862<class_1792> CONSUMABLE_COOLING = createItemTag("consumable/cooling");


    private static class_6862<class_1299<?>> createEntityTypeTag(String path) {
        return class_6862.method_40092(class_7924.field_41266, Thermoo.id(path));
    }

    private static class_6862<class_2248> createBlockTag(String path) {
        return class_6862.method_40092(class_7924.field_41254, Thermoo.id(path));
    }

    private static class_6862<class_1792> createItemTag(String path) {
        return class_6862.method_40092(class_7924.field_41197, Thermoo.id(path));
    }

    private ThermooTags() {
    }
}
