package com.github.thedeathlycow.thermoo.api.environment.attribute;

import com.github.thedeathlycow.thermoo.api.season.TemperateSeason;
import com.github.thedeathlycow.thermoo.api.season.TropicalSeason;
import com.github.thedeathlycow.thermoo.api.util.TemperatureRecord;
import com.github.thedeathlycow.thermoo.impl.CodecHelper;
import com.github.thedeathlycow.thermoo.impl.environment.attribute.TemperatureModifier;
import java.util.Optional;
import net.minecraft.class_12192;

/**
 * Thermoo analogue of {@link net.minecraft.class_12193}.
 * <p>
 * Provides the attribute type definitions for Thermoo's custom environment attributes.
 */
public final class ThermooAttributeTypes {
    /**
     * An attribute type that holds an optional temperate season. This attribute type is not interpolated.
     * <p>
     * This attribute type has no defined modifier operation.
     */
    public static final class_12192<Optional<TemperateSeason>> TEMPERATE_SEASON = class_12192.method_75631(
            CodecHelper.optionalCodec(TemperateSeason.CODEC)
    );

    /**
     * An attribute type that holds an optional tropical season. This attribute type is not interpolated.
     * <p>
     * This attribute type has no defined modifier operation.
     */
    public static final class_12192<Optional<TropicalSeason>> TROPICAL_SEASON = class_12192.method_75631(
            CodecHelper.optionalCodec(TropicalSeason.CODEC)
    );

    /**
     * An attribute type that holds a temperature record. This attribute type is interpolated.
     * <p>
     * It may be modified with the operations add, subtract, minimum, and maximum.
     */
    public static final class_12192<TemperatureRecord> TEMPERATURE = class_12192.method_75633(
            TemperatureRecord.CODEC,
            TemperatureModifier.TEMPERATURE_RECORD_LIBRARY,
            TemperatureModifier::lerp
    );

    private ThermooAttributeTypes() {

    }
}