package com.github.thedeathlycow.thermoo.api.environment.attribute;

import com.github.thedeathlycow.thermoo.api.season.TemperateSeason;
import com.github.thedeathlycow.thermoo.api.season.TropicalSeason;
import com.github.thedeathlycow.thermoo.api.util.TemperatureRecord;
import com.github.thedeathlycow.thermoo.api.util.TemperatureUnit;
import java.util.Optional;
import net.minecraft.class_12193;
import net.minecraft.class_12197;

/**
 * Thermoo analogue for {@link net.minecraft.class_12206}.
 * <p>
 * Defines Thermoo's custom environment attributes.
 */
public final class ThermooEnvironmentAttributes {
    /**
     * An environment attribute that stores a temperate season. By default, this attribute is empty.
     *
     * @see ThermooAttributeTypes#TEMPERATE_SEASON
     */
    public static final class_12197<Optional<TemperateSeason>> TEMPERATE_SEASON = class_12197.method_75648(ThermooAttributeTypes.TEMPERATE_SEASON)
            .method_75657(Optional.empty())
            .method_75660();

    /**
     * An environment attribute that stores a tropical season. By default, this attribute is empty.
     *
     * @see ThermooAttributeTypes#TROPICAL_SEASON
     */
    public static final class_12197<Optional<TropicalSeason>> TROPICAL_SEASON = class_12197.method_75648(ThermooAttributeTypes.TROPICAL_SEASON)
            .method_75657(Optional.empty())
            .method_75660();

    /**
     * An environment attribute that stores the current progress of a temperate season. This attribute's value is
     * clamped to the range [0, 1] when used, but may take any value permitted by {@link class_12193#field_63692}.
     * <p>
     * By default, this attribute has a value of 0. It may be interpolated, and modified with the operations alpha blend,
     * add, subtract, multiply, minimum, and maximum.
     *
     * @see class_12193#field_63692
     */
    public static final class_12197<Float> TEMPERATE_SEASON_PROGRESS = class_12197.method_75648(class_12193.field_63692)
            .method_75657(0f)
            .method_75660();

    /**
     * An environment attribute that stores the current progress of a tropical season. This attribute's value is
     * clamped to the range [0, 1] when used, but may take any value permitted by {@link class_12193#field_63692}.
     * <p>
     * By default, this attribute has a value of 0. It may be interpolated, and modified with the operations alpha blend,
     * add, subtract, multiply, minimum, and maximum.
     *
     * @see class_12193#field_63692
     */
    public static final class_12197<Float> TROPICAL_SEASON_PROGRESS = class_12197.method_75648(class_12193.field_63692)
            .method_75657(0f)
            .method_75660();

    /**
     * An environment attribute that stores a temperature record. This attribute defaults to 20°C.
     *
     * @see ThermooAttributeTypes#TEMPERATURE
     */
    public static final class_12197<TemperatureRecord> TEMPERATURE = class_12197.method_75648(ThermooAttributeTypes.TEMPERATURE)
            .method_75657(new TemperatureRecord(20, TemperatureUnit.CELSIUS))
            .method_75660();

    private ThermooEnvironmentAttributes() {

    }
}