package com.github.thedeathlycow.thermoo.api.environment.provider;

import com.github.thedeathlycow.thermoo.api.ThermooRegistries;
import com.github.thedeathlycow.thermoo.api.ThermooRegistryKeys;
import com.github.thedeathlycow.thermoo.api.environment.component.EnvironmentComponentTypes;
import com.mojang.serialization.Codec;
import net.minecraft.class_1937;
import net.minecraft.class_1959;
import net.minecraft.class_2338;
import net.minecraft.class_5381;
import net.minecraft.class_6880;
import net.minecraft.class_9323;

/**
 * Provides the environment parameters (such as temperature and relative humidity) of a position in a world and biome.
 */
public interface EnvironmentProvider {
    Codec<EnvironmentProvider> ELEMENT_CODEC = ThermooRegistries.ENVIRONMENT_PROVIDER_TYPE.method_39673()
            .dispatch("type", EnvironmentProvider::getType, EnvironmentProviderType::codec);

    Codec<class_6880<EnvironmentProvider>> HOLDER_CODEC = class_5381.method_29749(
            ThermooRegistryKeys.ENVIRONMENT_PROVIDER,
            ELEMENT_CODEC
    );

    /**
     * @deprecated This field was named based on Yarn mappings. Use {@link #HOLDER_CODEC} to better confirm to Official
     * Mappings.
     */
    @Deprecated(since = "8.1.0", forRemoval = true)
    Codec<class_6880<EnvironmentProvider>> ENTRY_CODEC = HOLDER_CODEC;

    /**
     * Builds the current environment parameter components at a point and biome in a world into a reducible builder.
     * <p>
     * The allowed component type keys must be registered in the
     * {@link ThermooRegistries#ENVIRONMENT_COMPONENT_TYPE environment component type registry}. A set of default
     * components for temperature and relative humidity are defined in
     * {@link EnvironmentComponentTypes}.
     *
     * @param level   The world/level being queried
     * @param pos     The position in the world to query
     * @param biome   The biome at the position in the world
     * @param builder A component map builder to append to
     */
    void buildCurrentComponents(class_1937 level, class_2338 pos, class_6880<class_1959> biome, class_9323.class_9324 builder);

    /**
     * @return Returns the type of this provider for dispatch
     */
    EnvironmentProviderType<? extends EnvironmentProvider> getType();
}