package com.github.thedeathlycow.thermoo.api.environment.provider;

import com.github.thedeathlycow.thermoo.api.ThermooRegistryKeys;
import com.github.thedeathlycow.thermoo.api.environment.EnvironmentDefinition;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import net.minecraft.class_1937;
import net.minecraft.class_1959;
import net.minecraft.class_2338;
import net.minecraft.class_6880;
import net.minecraft.class_6885;
import net.minecraft.class_6895;
import net.minecraft.class_9323;

/**
 * Applies modifiers to a base environment provider from a tag or list of environment providers
 * <p>
 * <strong>Note:</strong> In general, using the {@linkplain EnvironmentDefinition#priority() environment priority} is more
 * flexible than using this provider type.
 */
public final class ModifyEnvironmentProvider implements EnvironmentProvider {
    public static final MapCodec<ModifyEnvironmentProvider> CODEC = RecordCodecBuilder.mapCodec(
            instance -> instance.group(
                    class_6895.method_40340(ThermooRegistryKeys.ENVIRONMENT_PROVIDER)
                            .fieldOf("modifiers")
                            .forGetter(ModifyEnvironmentProvider::modifiers),
                    EnvironmentProvider.HOLDER_CODEC
                            .fieldOf("base")
                            .forGetter(ModifyEnvironmentProvider::base)
            ).apply(instance, ModifyEnvironmentProvider::new)
    );

    private final class_6885<EnvironmentProvider> modifiers;
    private final class_6880<EnvironmentProvider> base;

    private ModifyEnvironmentProvider(
            class_6885<EnvironmentProvider> modifiers,
            class_6880<EnvironmentProvider> base
    ) {
        this.modifiers = modifiers;
        this.base = base;
    }

    public ModifyEnvironmentProvider create(
            class_6885<EnvironmentProvider> modifiers,
            class_6880<EnvironmentProvider> base
    ) {
        return new ModifyEnvironmentProvider(modifiers, base);
    }

    /**
     * Builds the current components from the {@link #base()} and applies the modifiers to it, in the order that the
     * modifiers are specified.
     *
     * @param level   The world/level being queried
     * @param pos     The position in the world to query
     * @param biome   The biome at the position in the world
     * @param builder Component map builder to append to
     */
    @Override
    public void buildCurrentComponents(class_1937 level, class_2338 pos, class_6880<class_1959> biome, class_9323.class_9324 builder) {
        base.comp_349().buildCurrentComponents(level, pos, biome, builder);
        for (class_6880<EnvironmentProvider> modifier : this.modifiers) {
            modifier.comp_349().buildCurrentComponents(level, pos, biome, builder);
        }
    }

    @Override
    public EnvironmentProviderType<ModifyEnvironmentProvider> getType() {
        return EnvironmentProviderTypes.MODIFY;
    }

    /**
     * A list of modifiers that are applied to the base. Modifiers are applied in iteration order.
     *
     * @return Returns a registry entry list of providers
     */
    public class_6885<EnvironmentProvider> modifiers() {
        return modifiers;
    }

    /**
     * The base provider to be modified.
     *
     * @return Returns the provider registry entry
     */
    public class_6880<EnvironmentProvider> base() {
        return base;
    }
}