package com.github.thedeathlycow.thermoo.api.season;

import net.minecraft.class_3542;
import org.jetbrains.annotations.ApiStatus;

/**
 * Contains common functionality for all thermoo season types.
 *
 * @see TemperateSeason
 * @see TropicalSeason
 */
@ApiStatus.NonExtendable
public sealed interface ThermooSeason extends class_3542 permits TemperateSeason, TropicalSeason {
    /**
     * Creates a season state that represents the start of this season.
     */
    ThermooSeasonState<? extends ThermooSeason> createState();
}