package com.github.thedeathlycow.thermoo.api.temperature.effects;

import com.github.thedeathlycow.thermoo.api.temperature.TemperatureAware;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import net.minecraft.class_1309;
import net.minecraft.class_1320;
import net.minecraft.class_1322;
import net.minecraft.class_1324;
import net.minecraft.class_2960;
import net.minecraft.class_3218;
import net.minecraft.class_6880;
import net.minecraft.class_7923;

/**
 * A temperature effect that applies an attribute modifier to a victim.
 * <p>
 * Includes options to increase the modifier in strength with respect to the target's
 * {@linkplain TemperatureAware#thermoo$getTemperatureScale() current temperature scale}.
 */
public final class AttributeModifierTemperatureEffect extends TemperatureEffect<AttributeModifierTemperatureEffect.Config> {

    public static final Codec<Config> CODEC = RecordCodecBuilder.create(
            instance -> instance.group(
                    Codec.FLOAT
                            .fieldOf("value")
                            .forGetter(Config::value),
                    class_7923.field_41190.method_40294()
                            .fieldOf("attribute_type")
                            .forGetter(Config::attribute),
                    class_2960.field_25139
                            .fieldOf("id")
                            .forGetter(Config::id),
                    class_1322.class_1323.field_45742
                            .fieldOf("operation")
                            .forGetter(Config::operation)
            ).apply(instance, Config::new)
    );

    public AttributeModifierTemperatureEffect(Codec<Config> configCodec) {
        super(configCodec);
    }

    @Override
    public void apply(class_1309 victim, class_3218 serverWorld, Config config) {
        class_1324 attrInstance = victim.method_5996(config.attribute);
        if (attrInstance != null && !attrInstance.method_6196(config.id)) {
            attrInstance.method_26835(
                    new class_1322(
                            config.id,
                            config.value,
                            config.operation
                    )
            );
        }
    }

    @Override
    public boolean shouldApply(class_1309 victim, Config config) {
        // only apply when the entity has this attribute
        class_1324 attrInstance = victim.method_5996(config.attribute);
        return attrInstance != null;
    }

    @Override
    public void remove(class_1309 victim, class_3218 serverWorld, Config config) {
        super.remove(victim, serverWorld, config);
        class_1324 attributeInstance = victim.method_5996(config.attribute);
        if (attributeInstance != null) {
            attributeInstance.method_6200(config.id);
        }
    }


    public record Config(
            float value,
            class_6880<class_1320> attribute,
            class_2960 id,
            class_1322.class_1323 operation
    ) {
        /**
         * @return Returns the value of {@link #id}
         * @deprecated This field was named based on old name in Mojmap. Use {@link #id} to better conform to the new name.
         */
        @Deprecated(since = "9.0.0", forRemoval = true)
        public class_2960 location() {
            return id;
        }
    }
}
