package com.github.thedeathlycow.thermoo.api.temperature.effects;

import com.github.thedeathlycow.thermoo.api.temperature.TemperatureAware;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import net.minecraft.class_1309;
import net.minecraft.class_1320;
import net.minecraft.class_1322;
import net.minecraft.class_1324;
import net.minecraft.class_2960;
import net.minecraft.class_3218;
import net.minecraft.class_6880;
import net.minecraft.class_7923;


/**
 * A temperature effect that applies an attribute modifier to a victim that increases in strength with respect to the
 * current temperature scale, as computed by {@link TemperatureAware#thermoo$getTemperatureScale()}
 */
public final class ScalingAttributeModifierTemperatureEffect extends TemperatureEffect<ScalingAttributeModifierTemperatureEffect.Config> {

    public static final Codec<Config> CODEC = RecordCodecBuilder.create(
            instance -> instance.group(
                    Codec.FLOAT
                            .fieldOf("scale")
                            .orElse(1f)
                            .forGetter(Config::scale),
                    class_7923.field_41190.method_40294()
                            .fieldOf("attribute_type")
                            .forGetter(Config::attribute),
                    class_2960.field_25139
                            .fieldOf("id")
                            .forGetter(Config::id),
                    class_1322.class_1323.field_45742
                            .fieldOf("operation")
                            .forGetter(Config::operation)
            ).apply(instance, Config::new)
    );

    public ScalingAttributeModifierTemperatureEffect(Codec<Config> configCodec) {
        super(configCodec);
    }

    @Override
    public void apply(class_1309 victim, class_3218 serverLevel, Config config) {
        class_1324 attrInstance = victim.method_5996(config.attribute);
        if (attrInstance == null) {
            return;
        }

        // add the modifier back with greater strength
        double amount = config.scale * victim.thermoo$getTemperatureScale();

        attrInstance.method_26835(
                new class_1322(
                        config.id,
                        amount,
                        config.operation
                )
        );
    }

    @Override
    public boolean shouldApply(class_1309 victim, Config config) {
        // this effect will always apply as it scales with the temperature
        class_1324 attrInstance = victim.method_5996(config.attribute);

        if (attrInstance == null) {
            return false;
        }

        class_1322 modifier = attrInstance.method_6199(config.id);
        if (modifier == null) {
            return true;
        }

        double newAmount = config.scale * victim.thermoo$getTemperatureScale();
        double currentValue = modifier.comp_2449();

        boolean shouldApply = newAmount != currentValue;

        if (shouldApply) {
            // remove the modifier - even if the other predicate tests fail
            attrInstance.method_6200(config.id);
        }

        return shouldApply;
    }

    public record Config(
            float scale,
            class_6880<class_1320> attribute,
            class_2960 id,
            class_1322.class_1323 operation
    ) {
        /**
         * @return Returns the value of {@link #id}
         * @deprecated This field was named based on old name in Mojmap. Use {@link #id} to better conform to the new name.
         */
        @Deprecated(since = "9.0.0", forRemoval = true)
        public class_2960 location() {
            return id;
        }
    }
}
