package com.github.thedeathlycow.thermoo.api.temperature.event;

import com.github.thedeathlycow.thermoo.api.environment.component.EnvironmentComponentTypes;
import com.github.thedeathlycow.thermoo.api.temperature.Soakable;
import com.github.thedeathlycow.thermoo.api.temperature.TemperatureAware;
import net.minecraft.class_1309;
import net.minecraft.class_2338;
import net.minecraft.class_3218;
import net.minecraft.class_9323;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;

/**
 * Context objects for general temperature ticking events on temperature awares and soakables
 *
 * @param <T> The temperature aware type
 */
@ApiStatus.NonExtendable
public interface EnvironmentTickContext<T extends TemperatureAware & Soakable> {
    /**
     * The temperature aware/soakable being ticked
     */
    @NotNull
    T affected();

    /**
     * @deprecated This method was named based on Yarn Mappings. Use {@link #level()} to better conform to Official
     * Mappings.
     */
    @NotNull
    @Deprecated(since = "8.1.0", forRemoval = true)
    default class_3218 world() {
        return this.level();
    }

    /**
     * The server level of the affected temperature aware/soakable
     */
    @NotNull
    class_3218 level();

    /**
     * The block position of the affected temperature aware/soakable. This should be preferred over using methods such as
     * {@link class_1309#method_24515()} since it can correct for being slightly sunk into blocks like mud or soul sand
     * by taking the block position that is slightly above their actual {@linkplain class_1309#method_73189() position}.
     */
    @NotNull
    class_2338 pos();

    /**
     * The current environment components at the world and position.
     * <p>
     * No key is guaranteed to be mapped to a value, be sure to always check the result or use {@link class_9323#method_58695(net.minecraft.class_9331, Object)}.
     * <p>
     * Environment components are only looked up for players by default, for all other entity types this map is empty.
     *
     * @return Returns an {@link EnvironmentComponentTypes environment component map}
     */
    class_9323 components();
}