package com.github.thedeathlycow.thermoo.impl.attribute;

import net.minecraft.class_1220;
import net.minecraft.class_1309;
import net.minecraft.class_1322;
import net.minecraft.class_1324;

/**
 * Helper methods for attribute related functions
 */
public class AttributeHelper {

    private static final String PREFIX = "thermoo:generic.";

    public static String fixPrefixedAttributeIds(String id) {
        String normalizedID = class_1220.method_5193(id);

        String normalizedPrefix = class_1220.method_5193(PREFIX);
        if (normalizedID.startsWith(normalizedPrefix)) {
            return "thermoo:" + normalizedID.substring(normalizedPrefix.length());
        }

        return id;
    }

    public static void applyValueAsModifier(
            class_1309 entity,
            AttributeData attribute,
            double value
    ) {
        var modifier = new class_1322(
                attribute.location(),
                value,
                class_1322.class_1323.field_6328
        );

        class_1324 attributeInstance = entity.method_5996(attribute.attribute());

        if (attributeInstance == null) {
            throw new IllegalStateException("Attribute not found on " + entity.method_5864() + ": " + attribute);
        }

        attributeInstance.method_26835(modifier);
    }

    private AttributeHelper() {

    }

}
