package com.github.thedeathlycow.thermoo.impl.compat;

import com.github.thedeathlycow.thermoo.impl.Thermoo;
import com.github.thedeathlycow.thermoo.impl.config.ThermooConfig;
import net.fabricmc.fabric.api.client.event.lifecycle.v1.ClientTickEvents;
import net.fabricmc.loader.api.FabricLoader;
import net.fabricmc.loader.api.ModContainer;
import net.fabricmc.loader.api.VersionParsingException;
import net.fabricmc.loader.api.metadata.ModMetadata;
import net.minecraft.class_124;
import net.minecraft.class_2558;
import net.minecraft.class_2561;
import net.minecraft.class_2583;
import net.minecraft.class_310;
import net.minecraft.class_5250;
import net.minecraft.class_746;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import java.io.IOException;
import java.net.URI;
import java.net.http.HttpClient;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public class ThermooPatchesNag implements ClientTickEvents.EndTick {
    private static final Logger LOGGER = LoggerFactory.getLogger(Thermoo.MODID + "-patch-nag");

    private static final class_2583 LINK_STYLE = class_2583.field_24360
            .method_30938(true)
            .method_10977(class_124.field_1060)
            .method_10958(new class_2558.class_10608(URI.create("https://www.modrinth.com/mod/thermoo-patches")));

    private static final ThermooPatchesNag INSTANCE = new ThermooPatchesNag();

    private final List<ModContainer> patchAvailableMods = Collections.synchronizedList(new ArrayList<>());

    private boolean naggedPlayer = false;

    @Nullable
    private class_2561 nagMessage = null;

    public static void initialize(ThermooConfig config) {
        if (enableNag(config)) {
            INSTANCE.fetchAsync(config);
            ClientTickEvents.END_CLIENT_TICK.register(INSTANCE);
        }
    }

    private static boolean enableNag(ThermooConfig config) {
        return !FabricLoader.getInstance().isModLoaded("thermoo-patches") && config.enableThermooPatchesNag();
    }

    @Override
    public void onEndTick(class_310 client) {
        if (this.naggedPlayer) {
            return;
        }

        class_2561 nagMessageText = this.getNagMessage();
        class_746 player = client.field_1724;

        if (nagMessageText != null && player != null) {
            this.naggedPlayer = true;
            player.method_7353(nagMessageText, false);
            LOGGER.warn(nagMessageText.getString());
        }
    }

    private void fetchAsync(ThermooConfig config) {
        Thread.ofVirtual().start(() -> {
            try {
                this.fetch(config);
            } catch (Exception e) {
                LOGGER.error("Error fetching Thermoo Patches patch list", e);
            }
        });
    }

    private void fetch(ThermooConfig config) {
        LOGGER.info("Fetching Thermoo Patches patch list data...");
        List<ModContainer> patchAvailableMods;

        try (HttpClient client = HttpClient.newHttpClient()) {
            PatchList patches = PatchListService.fetchPatchList(client, config.thermooPatchesPatchListUrl());
            patchAvailableMods = patches.getPatchAvailableMods(FabricLoader.getInstance());
        } catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new RuntimeException(e);
        } catch (IOException | VersionParsingException e) {
            throw new RuntimeException(e);
        }

        if (!patchAvailableMods.isEmpty()) {
            LOGGER.warn("Thermoo Patches is recommended for this mod set!");
            this.patchAvailableMods.addAll(patchAvailableMods);
        } else if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("Your mod set is patched with Thermoo Patches, great job!");
        }
    }

    @Nullable
    private class_2561 getNagMessage() {
        if (!this.patchAvailableMods.isEmpty()) {
            this.nagMessage = this.createNagMessage();
        }

        return this.nagMessage;
    }

    private class_2561 createNagMessage() {
        class_5250 message = class_2561.method_43470("").method_27692(class_124.field_1077);

        message.method_27693("\n");
        message.method_10852(class_2561.method_43471("text.thermoo.thermoo-patches-nag.body"));
        message.method_27693("\n\n");

        synchronized (this.patchAvailableMods) {
            patchAvailableMods.forEach(mod -> {
                ModMetadata metadata = mod.getMetadata();
                class_2561 modEntry = class_2561.method_43469(
                        "text.thermoo.thermoo-patches-nag.item",
                        metadata.getName(),
                        metadata.getId()
                ).method_27692(class_124.field_1054);

                message.method_10852(modEntry);
                message.method_27693("\n");
            });
        }

        message.method_27693("\n");
        message.method_10852(class_2561.method_43471("text.thermoo.thermoo-patches-nag.footer"));
        message.method_10852(
                class_2561.method_43470("\nhttps://www.modrinth.com/mod/thermoo-patches\n\n")
                        .method_10862(LINK_STYLE)
        );
        message.method_10852(class_2561.method_43471("text.thermoo.thermoo-patches-nag.disable"));

        return message;
    }

    private ThermooPatchesNag() {

    }
}