package com.github.thedeathlycow.thermoo.impl.environment;

import com.github.thedeathlycow.thermoo.api.ThermooRegistryKeys;
import com.github.thedeathlycow.thermoo.api.environment.EnvironmentDefinition;
import com.github.thedeathlycow.thermoo.api.environment.EnvironmentLookup;
import com.github.thedeathlycow.thermoo.api.environment.attribute.ThermooEnvironmentAttributes;
import com.github.thedeathlycow.thermoo.api.environment.component.EnvironmentComponentTypes;
import com.github.thedeathlycow.thermoo.api.environment.provider.EnvironmentProvider;
import com.github.thedeathlycow.thermoo.api.util.TemperatureRecord;
import com.github.thedeathlycow.thermoo.impl.Thermoo;
import net.fabricmc.fabric.api.event.lifecycle.v1.ServerLifecycleEvents;
import net.minecraft.class_12205;
import net.minecraft.class_1937;
import net.minecraft.class_1959;
import net.minecraft.class_2338;
import net.minecraft.class_2378;
import net.minecraft.class_6880;
import net.minecraft.class_7924;
import net.minecraft.class_9323;
import net.minecraft.server.MinecraftServer;
import org.jetbrains.annotations.VisibleForTesting;

import java.util.Comparator;
import java.util.List;
import java.util.Objects;
import java.util.stream.Stream;

public class EnvironmentLookupImpl implements EnvironmentLookup {
    public static final EnvironmentLookupImpl INSTANCE = new EnvironmentLookupImpl();

    public static void initialize() {
        ServerLifecycleEvents.SERVER_STARTED.register(INSTANCE::addProvidersToBiomes);
    }

    @Override
    public class_9323 findEnvironmentComponents(class_1937 level, class_2338 pos) {
        class_6880<class_1959> biome = level.method_23753(pos);
        return this.findEnvironmentComponentsForBiome(level, pos, biome);
    }

    public class_9323 findEnvironmentComponentsForBiome(class_1937 level, class_2338 pos, class_6880<class_1959> biome) {
        class_9323.class_9324 builder = class_9323.method_57827();

        class_12205 attributes = level.method_75728();
        TemperatureRecord baseValue = attributes.method_75697(ThermooEnvironmentAttributes.TEMPERATURE, pos);
        builder.method_57840(EnvironmentComponentTypes.TEMPERATURE, baseValue);

        for (class_6880<EnvironmentProvider> provider : this.getProviders(biome)) {
            provider.comp_349().buildCurrentComponents(level, pos, biome, builder);
        }
        return builder.method_57838();
    }

    private List<class_6880<EnvironmentProvider>> getProviders(class_6880<class_1959> biomeEntry) {
        class_1959 biome = biomeEntry.comp_349();
        return ((ThermooBiome) (Object) biome).thermoo$getEnvironmentProviders();
    }

    private void addProvidersToBiomes(MinecraftServer server) {
        class_2378<EnvironmentDefinition> envRegistry = server.method_30611().method_30530(ThermooRegistryKeys.ENVIRONMENT);
        class_2378<class_1959> biomeRegistry = server.method_30611().method_30530(class_7924.field_41236);

        biomeRegistry.method_42017().forEach(holder -> {
            List<class_6880<EnvironmentProvider>> providers = getAllMatchingEnvironments(holder, envRegistry)
                    .map(EnvironmentDefinition::provider)
                    .toList();

            class_1959 biome = holder.comp_349();
            Objects.requireNonNull(biome);
            ThermooBiome extendedBiome = ((ThermooBiome) (Object) biome);
            extendedBiome.thermoo$replaceProviders(providers);

            if (Thermoo.LOGGER.isDebugEnabled()) {
                Thermoo.LOGGER.debug("Found {} providers for {}.", providers.size(), holder.method_40237().method_29177());
            }
        });
    }

    @VisibleForTesting
    public static Stream<EnvironmentDefinition> getAllMatchingEnvironments(class_6880<class_1959> biome, class_2378<EnvironmentDefinition> envRegistry) {
        return envRegistry.method_10220()
                .filter(entry -> entry.providesFor(biome))
                .sorted(Comparator.comparingInt(EnvironmentDefinition::priority).reversed());
    }
}