package com.github.thedeathlycow.thermoo.impl.environment.attribute;

import com.github.thedeathlycow.thermoo.api.util.TemperatureRecord;
import com.mojang.serialization.Codec;
import java.util.Map;
import net.minecraft.class_12197;
import net.minecraft.class_12210;
import net.minecraft.class_12212;
import net.minecraft.class_3532;

public interface TemperatureModifier<Argument> extends class_12212<TemperatureRecord, Argument> {
    Simple ADD = TemperatureRecord::sum;
    Simple SUBTRACT = (a, b) -> a.sum(new TemperatureRecord(-b.value(), b.unit()));
    Simple MINIMUM = (a, b) -> a.compareTo(b) < 0 ? a : b;
    Simple MAXIMUM = (a, b) -> a.compareTo(b) < 0 ? b : a;

    Map<class_12212.class_12213, class_12212<TemperatureRecord, ?>> TEMPERATURE_RECORD_LIBRARY = Map.of(
            class_12212.class_12213.field_63773,
            ADD,
            class_12212.class_12213.field_63774,
            SUBTRACT,
            class_12212.class_12213.field_63776,
            MINIMUM,
            class_12212.class_12213.field_63777,
            MAXIMUM
    );

    static TemperatureRecord lerp(float delta, TemperatureRecord a, TemperatureRecord b) {
        double interpolated = class_3532.method_16436(delta, a.value(), b.valueInUnit(a.unit()));
        return new TemperatureRecord(interpolated, a.unit());
    }

    @FunctionalInterface
    interface Simple extends TemperatureModifier<TemperatureRecord> {
        @Override
        default Codec<TemperatureRecord> argumentCodec(class_12197<TemperatureRecord> attribute) {
            return TemperatureRecord.CODEC;
        }

        @Override
        default class_12210<TemperatureRecord> argumentKeyframeLerp(class_12197<TemperatureRecord> attribute) {
            return TemperatureModifier::lerp;
        }
    }
}