package com.github.thedeathlycow.thermoo.mixin.common;

import com.github.thedeathlycow.thermoo.impl.item.ModifyItemAttributeModifiersImpl;
import com.llamalad7.mixinextras.injector.wrapoperation.Operation;
import com.llamalad7.mixinextras.injector.wrapoperation.WrapOperation;
import org.apache.commons.lang3.function.TriConsumer;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;

import java.util.function.BiConsumer;
import net.minecraft.class_1304;
import net.minecraft.class_1320;
import net.minecraft.class_1322;
import net.minecraft.class_1799;
import net.minecraft.class_6880;
import net.minecraft.class_9274;
import net.minecraft.class_9285;
import net.minecraft.class_9326;
import net.minecraft.class_9334;

@Mixin(class_1799.class)
public abstract class ItemStackMixin {
    @Shadow
    public abstract class_9326 getComponentsPatch();

    @WrapOperation(
            method = "forEachModifier(Lnet/minecraft/world/entity/EquipmentSlotGroup;Lorg/apache/commons/lang3/function/TriConsumer;)V",
            at = @At(
                    value = "INVOKE",
                    target = "Lnet/minecraft/world/item/component/ItemAttributeModifiers;forEach(Lnet/minecraft/world/entity/EquipmentSlotGroup;Lorg/apache/commons/lang3/function/TriConsumer;)V"
            )
    )
    private void hookItemModifierEvent(
            class_9285 instance,
            class_9274 slot,
            TriConsumer<class_6880<class_1320>, class_1322, class_9285.class_11193> attributeConsumer,
            Operation<Void> original
    ) {
        // prevent overriding modified components from commands
        if (this.getComponentsPatch().method_57845(class_9334.field_49636) == null) {
            instance = ModifyItemAttributeModifiersImpl.invoke((class_1799) (Object) this, instance);
        }
        original.call(instance, slot, attributeConsumer);
    }


    @WrapOperation(
            method = "forEachModifier(Lnet/minecraft/world/entity/EquipmentSlot;Ljava/util/function/BiConsumer;)V",
            at = @At(
                    value = "INVOKE",
                    target = "Lnet/minecraft/world/item/component/ItemAttributeModifiers;forEach(Lnet/minecraft/world/entity/EquipmentSlot;Ljava/util/function/BiConsumer;)V"
            )
    )
    private void hookItemModifierEvent(
            class_9285 instance,
            class_1304 slot,
            BiConsumer<class_6880<class_1320>, class_1322> attributeConsumer,
            Operation<Void> original
    ) {
        // prevent overriding modified components from commands
        if (this.getComponentsPatch().method_57845(class_9334.field_49636) == null) {
            instance = ModifyItemAttributeModifiersImpl.invoke((class_1799) (Object) this, instance);
        }
        original.call(instance, slot, attributeConsumer);
    }
}