package com.github.thedeathlycow.thermoo.mixin.common;

import com.github.thedeathlycow.thermoo.impl.attribute.AttributeData;
import com.github.thedeathlycow.thermoo.impl.attribute.AttributeHelper;
import net.minecraft.class_1299;
import net.minecraft.class_1309;
import net.minecraft.class_1937;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(class_1309.class)
public abstract class LivingEntityAttributeMixin {

    @Inject(
            method = "<init>",
            at = @At("TAIL")
    )
    private void addDefaultBoundsModifiers(class_1299<? extends class_1309> entityType, class_1937 level, CallbackInfo ci) {
        class_1309 instance = (class_1309) (Object) this;

        for (var attribute : AttributeData.values()) {
            double value = attribute.baseValueEvent().invoker().getBaseValue(instance);
            if (value != 0) {
                AttributeHelper.applyValueAsModifier(instance, attribute, value);
            }
        }
    }
}
