package com.github.thedeathlycow.thermoo.impl.item;

import com.github.thedeathlycow.thermoo.api.item.ModifyItemAttributeModifiersCallback;
import com.github.thedeathlycow.thermoo.mixin.common.accessor.AttributeModifiersComponentBuilderAccessor;
import it.unimi.dsi.fastutil.Pair;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.class_1320;
import net.minecraft.class_1799;
import net.minecraft.class_2960;
import net.minecraft.class_5321;
import net.minecraft.class_9285;

public final class ModifyItemAttributeModifiersImpl {
    public static class_9285 invoke(class_1799 stack, class_9285 base) {
        class_9285.class_9286 builder = class_9285.method_57480();
        AttributeModifiersComponentBuilderAccessor accessor = (AttributeModifiersComponentBuilderAccessor) builder;
        accessor.scorchful$getEntries().addAll(base.comp_2393());

        ModifyItemAttributeModifiersCallback.EVENT.invoker().modifyAttributeModifiers(stack, builder);

        return new class_9285(removeDuplicates(builder.method_57486().comp_2393()));
    }

    private static List<class_9285.class_9287> removeDuplicates(Collection<class_9285.class_9287> modifiers) {
        Map<Pair<class_5321<class_1320>, class_2960>, class_9285.class_9287> map = new LinkedHashMap<>();

        // de-duplicates the modifiers to remove any entries that modify the same attribute and have the same ID
        for (var modifier : modifiers) {
            Pair<class_5321<class_1320>, class_2960> key = Pair.of(
                    modifier.comp_2395().method_40230().orElseThrow(),
                    modifier.comp_2396().comp_2447()
            );
            map.put(key, modifier);
        }

        return map.values().stream().toList();
    }

    private ModifyItemAttributeModifiersImpl() {

    }
}