/*
 * Decompiled with CFR 0.152.
 */
package com.github.thedeathlycow.thermoo.api.environment.provider;

import com.github.thedeathlycow.thermoo.api.environment.provider.EnvironmentProvider;
import com.github.thedeathlycow.thermoo.api.environment.provider.EnvironmentProviderType;
import com.github.thedeathlycow.thermoo.api.environment.provider.EnvironmentProviderTypes;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.Objects;
import java.util.Optional;
import net.minecraft.class_1937;
import net.minecraft.class_1944;
import net.minecraft.class_1959;
import net.minecraft.class_2338;
import net.minecraft.class_6880;
import net.minecraft.class_9323;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class LightThresholdLightProvider
implements EnvironmentProvider {
    public static final MapCodec<LightThresholdLightProvider> CODEC = RecordCodecBuilder.mapCodec(instance -> instance.group((App)Codec.stringResolver(light -> light.name().toLowerCase(), name -> class_1944.valueOf((String)name.toUpperCase())).optionalFieldOf("light_type").forGetter(LightThresholdLightProvider::lightType), (App)Codec.BOOL.optionalFieldOf("apply_ambient_darkness", (Object)true).forGetter(LightThresholdLightProvider::applyAmbientDarkness), (App)Codec.intRange((int)0, (int)15).fieldOf("threshold").forGetter(LightThresholdLightProvider::threshold), (App)EnvironmentProvider.ENTRY_CODEC.fieldOf("above").forGetter(LightThresholdLightProvider::above), (App)EnvironmentProvider.ENTRY_CODEC.fieldOf("below").forGetter(LightThresholdLightProvider::below)).apply((Applicative)instance, LightThresholdLightProvider::new));
    private final Optional<class_1944> lightType;
    private final boolean applyAmbientDarkness;
    private final int threshold;
    private final class_6880<EnvironmentProvider> above;
    private final class_6880<EnvironmentProvider> below;

    @Contract(value="_,_,_->new")
    public static Builder builder(int threshold, @NotNull class_6880<EnvironmentProvider> above, @NotNull class_6880<EnvironmentProvider> below) {
        if (threshold < 0 || threshold > 15) {
            throw new IllegalArgumentException("Threshold must be between 0 and 15 but is " + threshold);
        }
        Objects.requireNonNull(above);
        Objects.requireNonNull(below);
        return new Builder(threshold, above, below);
    }

    private LightThresholdLightProvider(Optional<class_1944> lightType, boolean applyAmbientDarkness, int threshold, class_6880<EnvironmentProvider> above, class_6880<EnvironmentProvider> below) {
        this.lightType = lightType;
        this.applyAmbientDarkness = applyAmbientDarkness;
        this.threshold = threshold;
        this.above = above;
        this.below = below;
    }

    @Override
    public void buildCurrentComponents(class_1937 world, class_2338 pos, class_6880<class_1959> biome, class_9323.class_9324 builder) {
        int lightLevel = this.lightType.map(type -> world.method_8314(type, pos)).orElseGet(() -> world.method_22339(pos));
        if (this.applyAmbientDarkness && this.lightType.orElse(null) == class_1944.field_9284) {
            lightLevel -= world.method_8594();
        }
        if (lightLevel >= this.threshold) {
            ((EnvironmentProvider)this.above.comp_349()).buildCurrentComponents(world, pos, biome, builder);
        } else {
            ((EnvironmentProvider)this.below.comp_349()).buildCurrentComponents(world, pos, biome, builder);
        }
    }

    public EnvironmentProviderType<LightThresholdLightProvider> getType() {
        return EnvironmentProviderTypes.LIGHT_THRESHOLD;
    }

    public Optional<class_1944> lightType() {
        return this.lightType;
    }

    public boolean applyAmbientDarkness() {
        return this.applyAmbientDarkness;
    }

    public int threshold() {
        return this.threshold;
    }

    public class_6880<EnvironmentProvider> above() {
        return this.above;
    }

    public class_6880<EnvironmentProvider> below() {
        return this.below;
    }

    public static final class Builder {
        @Nullable
        private class_1944 lightType = null;
        private boolean applyAmbientDarkness = true;
        private final int threshold;
        private final class_6880<EnvironmentProvider> above;
        private final class_6880<EnvironmentProvider> below;

        private Builder(int threshold, class_6880<EnvironmentProvider> above, class_6880<EnvironmentProvider> below) {
            this.threshold = threshold;
            this.above = above;
            this.below = below;
        }

        @Contract(value="->this")
        public Builder ignoreAmbientDarkness() {
            this.applyAmbientDarkness = false;
            return this;
        }

        @Contract(value="_->this")
        public Builder withLightType(class_1944 lightType) {
            this.lightType = lightType;
            return this;
        }

        @Contract(value="->new")
        public LightThresholdLightProvider build() {
            return new LightThresholdLightProvider(Optional.ofNullable(this.lightType), this.applyAmbientDarkness, this.threshold, this.above, this.below);
        }
    }
}

